/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.GenericQueue;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpCookedConnection;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;

public class OtpMbox {
    OtpNode home;
    OtpErlangPid self;
    GenericQueue queue;
    String name;
    Links links;
    private long unlink_id;

    OtpMbox(OtpNode home, OtpErlangPid self, String name) {
        this.self = self;
        this.home = home;
        this.name = name;
        this.unlink_id = 1L;
        this.queue = new GenericQueue();
        this.links = new Links(10);
    }

    OtpMbox(OtpNode home, OtpErlangPid self) {
        this(home, self, null);
    }

    public OtpErlangPid self() {
        return this.self;
    }

    public synchronized boolean registerName(String aname) {
        return this.home.registerName(aname, this);
    }

    public String getName() {
        return this.name;
    }

    public OtpErlangObject receive() throws OtpErlangExit, OtpErlangDecodeException {
        try {
            return this.receiveMsg().getMsg();
        }
        catch (OtpErlangExit e) {
            throw e;
        }
        catch (OtpErlangDecodeException f) {
            throw f;
        }
    }

    public OtpErlangObject receive(long timeout) throws OtpErlangExit, OtpErlangDecodeException {
        try {
            OtpMsg m = this.receiveMsg(timeout);
            if (m != null) {
                return m.getMsg();
            }
        }
        catch (OtpErlangExit e) {
            throw e;
        }
        catch (OtpErlangDecodeException f) {
            throw f;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public OtpInputStream receiveBuf() throws OtpErlangExit {
        return this.receiveMsg().getMsgBuf();
    }

    public OtpInputStream receiveBuf(long timeout) throws InterruptedException, OtpErlangExit {
        OtpMsg m = this.receiveMsg(timeout);
        if (m != null) {
            return m.getMsgBuf();
        }
        return null;
    }

    public OtpMsg receiveMsg() throws OtpErlangExit {
        OtpMsg m = (OtpMsg)this.queue.get();
        switch (m.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject o = m.getMsg();
                    throw new OtpErlangExit(o, m.getSenderPid());
                }
                catch (OtpErlangDecodeException e) {
                    throw new OtpErlangExit("unknown", m.getSenderPid());
                }
            }
        }
        return m;
    }

    public OtpMsg receiveMsg(long timeout) throws InterruptedException, OtpErlangExit {
        OtpMsg m = (OtpMsg)this.queue.get(timeout);
        if (m == null) {
            return null;
        }
        switch (m.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject o = m.getMsg();
                    throw new OtpErlangExit(o, m.getSenderPid());
                }
                catch (OtpErlangDecodeException e) {
                    throw new OtpErlangExit("unknown", m.getSenderPid());
                }
            }
        }
        return m;
    }

    public void send(OtpErlangPid to, OtpErlangObject msg) {
        try {
            String node = to.node();
            if (node.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(to, (OtpErlangObject)msg.clone()));
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                conn.send(this.self, to, msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send(String aname, OtpErlangObject msg) {
        this.home.deliver(new OtpMsg(this.self, aname, (OtpErlangObject)msg.clone()));
    }

    public void send(String aname, String node, OtpErlangObject msg) {
        try {
            String currentNode = this.home.node();
            if (node.equals(currentNode)) {
                this.send(aname, msg);
            } else if (node.indexOf(64, 0) < 0 && node.equals(currentNode.substring(0, currentNode.indexOf(64, 0)))) {
                this.send(aname, msg);
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                conn.send(this.self, aname, msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exit(OtpErlangObject reason) {
        this.home.closeMbox(this, reason);
    }

    public void exit(String reason) {
        this.exit(new OtpErlangAtom(reason));
    }

    public void exit(OtpErlangPid to, OtpErlangObject reason) {
        this.exit(2, to, reason);
    }

    public void exit(OtpErlangPid to, String reason) {
        this.exit(to, new OtpErlangAtom(reason));
    }

    private void exit(int arity, OtpErlangPid to, OtpErlangObject reason) {
        try {
            String node = to.node();
            if (node.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(3, this.self, to, reason));
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                switch (arity) {
                    case 1: {
                        conn.exit(this.self, to, reason);
                        break;
                    }
                    case 2: {
                        conn.exit2(this.self, to, reason);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void link(OtpErlangPid to) throws OtpErlangExit {
        block7: {
            if (!this.links.addLink(this.self, to, true)) {
                return;
            }
            try {
                String node = to.node();
                if (node.equals(this.home.node())) {
                    if (!this.home.deliver(new OtpMsg(1, this.self, to))) {
                        throw new OtpErlangExit("noproc", to);
                    }
                    break block7;
                }
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn != null) {
                    conn.link(this.self, to);
                    conn.node_link(this.self, to, true);
                    break block7;
                }
                throw new OtpErlangExit("noproc", to);
            }
            catch (OtpErlangExit e) {
                this.links.removeLink(this.self, to);
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void unlink(OtpErlangPid to) {
        long unlink_id;
        if ((unlink_id = this.unlink_id++) == 0L) {
            unlink_id = this.unlink_id++;
        }
        if (this.links.setUnlinking(this.self, to, unlink_id)) {
            try {
                String node = to.node();
                if (node.equals(this.home.node())) {
                    this.home.deliver(new OtpMsg(4, this.self, to));
                } else {
                    OtpCookedConnection conn = this.home.getConnection(node);
                    if (conn != null) {
                        conn.unlink(this.self, to, unlink_id);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized OtpErlangPid[] linked() {
        return this.links.remotePids();
    }

    public boolean ping(String node, long timeout) {
        return this.home.ping(node, timeout);
    }

    public String[] getNames() {
        return this.home.getNames();
    }

    public OtpErlangPid whereis(String aname) {
        return this.home.whereis(aname);
    }

    public void close() {
        this.home.closeMbox(this);
    }

    protected void finalize() {
        this.close();
        this.queue.flush();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpMbox)) {
            return false;
        }
        OtpMbox m = (OtpMbox)o;
        return m.self.equals(this.self);
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    void deliver(OtpMsg m) {
        switch (m.type()) {
            case 1: 
            case 3: 
            case 4: 
            case 35: 
            case 36: {
                this.handle_link_operation(m);
                break;
            }
            default: {
                this.queue.put(m);
            }
        }
    }

    private synchronized void handle_link_operation(OtpMsg m) {
        OtpErlangPid remote = m.getSenderPid();
        String node = remote.node();
        boolean is_local = node.equals(this.home.node());
        OtpCookedConnection conn = is_local ? null : this.home.getConnection(node);
        switch (m.type()) {
            case 1: {
                if (!this.links.addLink(this.self, remote, false) || is_local) break;
                if (conn != null) {
                    conn.node_link(this.self, remote, true);
                    break;
                }
                this.links.removeLink(this.self, remote);
                this.queue.put(new OtpMsg(3, remote, this.self, new OtpErlangAtom("noconnection")));
                break;
            }
            case 4: 
            case 35: {
                long unlink_id = m.getUnlinkId();
                boolean removed = this.links.removeActiveLink(this.self, remote);
                try {
                    if (is_local) {
                        this.home.deliver(new OtpMsg(36, this.self, remote, unlink_id));
                        break;
                    }
                    if (conn == null) break;
                    if (removed) {
                        conn.node_link(this.self, remote, false);
                    }
                    conn.unlink_ack(this.self, remote, unlink_id);
                }
                catch (Exception exception) {}
                break;
            }
            case 36: {
                this.links.removeUnlinkingLink(this.self, m.getSenderPid(), m.getUnlinkId());
                break;
            }
            case 3: {
                if (!this.links.removeActiveLink(this.self, m.getSenderPid())) break;
                this.queue.put(m);
            }
        }
    }

    synchronized void breakLinks(OtpErlangObject reason) {
        Link[] l = this.links.clearLinks();
        if (l != null) {
            int len = l.length;
            for (int i = 0; i < len; ++i) {
                OtpCookedConnection conn;
                if (l[i].getUnlinking() != 0L) continue;
                OtpErlangPid remote = l[i].remote();
                String node = remote.node();
                if (!node.equals(this.home.node()) && (conn = this.home.getConnection(node)) != null) {
                    conn.node_link(this.self, remote, false);
                }
                this.exit(1, remote, reason);
            }
        }
    }
}

