/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;

public class OtpMsg {
    public static final int linkTag = 1;
    public static final int sendTag = 2;
    public static final int exitTag = 3;
    public static final int unlinkTag = 4;
    public static final int regSendTag = 6;
    public static final int exit2Tag = 8;
    protected int tag;
    protected OtpInputStream paybuf;
    protected OtpErlangObject payload;
    protected OtpErlangPid from;
    protected OtpErlangPid to;
    protected String toName;
    protected long unlink_id;

    OtpMsg(OtpErlangPid to, OtpInputStream paybuf) {
        this.tag = 2;
        this.from = null;
        this.to = to;
        this.toName = null;
        this.paybuf = paybuf;
        this.payload = null;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid to, OtpErlangObject payload) {
        this.tag = 2;
        this.from = null;
        this.to = to;
        this.toName = null;
        this.paybuf = null;
        this.payload = payload;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid from, String toName, OtpInputStream paybuf) {
        this.tag = 6;
        this.from = from;
        this.toName = toName;
        this.to = null;
        this.paybuf = paybuf;
        this.payload = null;
        this.unlink_id = 0L;
    }

    OtpMsg(OtpErlangPid from, String toName, OtpErlangObject payload) {
        this.tag = 6;
        this.from = from;
        this.toName = toName;
        this.to = null;
        this.paybuf = null;
        this.payload = payload;
        this.unlink_id = 0L;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to, OtpErlangObject reason) {
        this.tag = tag;
        this.from = from;
        this.to = to;
        this.unlink_id = 0L;
        this.paybuf = null;
        this.payload = reason;
        this.unlink_id = 0L;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to, String reason) {
        this.tag = tag;
        this.from = from;
        this.to = to;
        this.paybuf = null;
        this.payload = new OtpErlangAtom(reason);
        this.unlink_id = 0L;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to) {
        this.tag = this.drop_tt_tag(tag);
        this.from = from;
        this.to = to;
        this.unlink_id = 0L;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to, long unlink_id) {
        this.tag = this.drop_tt_tag(tag);
        this.from = from;
        this.to = to;
        this.unlink_id = unlink_id;
    }

    private int drop_tt_tag(int tag) {
        switch (tag) {
            case 12: {
                return 2;
            }
            case 13: {
                return 3;
            }
            case 16: {
                return 6;
            }
            case 18: {
                return 8;
            }
        }
        return tag;
    }

    long getUnlinkId() {
        return this.unlink_id;
    }

    OtpInputStream getMsgBuf() {
        return this.paybuf;
    }

    public int type() {
        return this.tag;
    }

    public OtpErlangObject getMsg() throws OtpErlangDecodeException {
        if (this.payload == null) {
            this.payload = this.paybuf.read_any();
        }
        return this.payload;
    }

    public String getRecipientName() {
        return this.toName;
    }

    public OtpErlangPid getRecipientPid() {
        return this.to;
    }

    public Object getRecipient() {
        if (this.toName != null) {
            return this.toName;
        }
        return this.to;
    }

    public OtpErlangPid getSenderPid() {
        return this.from;
    }
}

