/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpGenericTransportFactory;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpServerTransport;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.IOException;
import java.net.UnknownHostException;

public class OtpSelf
extends OtpLocalNode {
    private final OtpServerTransport sock;
    private final OtpErlangPid pid;

    public OtpSelf(String node) throws IOException {
        this(node, defaultCookie, 0);
    }

    public OtpSelf(String node, OtpTransportFactory transportFactory) throws IOException {
        this(node, defaultCookie, 0, transportFactory);
    }

    public OtpSelf(String node, String cookie) throws IOException {
        this(node, cookie, 0);
    }

    public OtpSelf(String node, String cookie, OtpTransportFactory transportFactory) throws IOException {
        this(node, cookie, 0, transportFactory);
    }

    public OtpSelf(String node, String cookie, int port) throws IOException {
        super(node, cookie);
        this.sock = this.createServerTransport(port);
        this.port = port != 0 ? port : this.sock.getLocalPort();
        this.pid = this.createPid();
    }

    public OtpSelf(String node, String cookie, int port, OtpTransportFactory transportFactory) throws IOException {
        super(node, cookie, transportFactory);
        if (transportFactory instanceof OtpGenericTransportFactory) {
            this.sock = this.createServerTransport(this);
        } else {
            this.sock = this.createServerTransport(port);
            this.port = port != 0 ? port : this.sock.getLocalPort();
        }
        this.pid = this.createPid();
    }

    public OtpErlangPid pid() {
        return this.pid;
    }

    public boolean publishPort() throws IOException {
        if (this.getEpmd() != null) {
            return false;
        }
        OtpEpmd.publishPort(this);
        return this.getEpmd() != null;
    }

    public void unPublishPort() {
        OtpEpmd.unPublishPort(this);
        try {
            if (this.epmd != null) {
                this.epmd.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.epmd = null;
    }

    public OtpConnection accept() throws IOException, OtpAuthException {
        OtpTransport newsock = null;
        try {
            newsock = this.sock.accept();
            return new OtpConnection(this, newsock);
        }
        catch (IOException e) {
            try {
                if (newsock != null) {
                    newsock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public OtpConnection connect(OtpPeer other) throws IOException, UnknownHostException, OtpAuthException {
        return new OtpConnection(this, other);
    }
}

