/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin;

import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.commons.io.input.CharSequenceReader;
import org.n0pe.asadmin.AsAdminException;
import org.n0pe.asadmin.IAsAdminCmd;

public abstract class AbstractAsAdminCmd
implements IAsAdminCmd {
    public static final String[] EMPTY_ARRAY = new String[0];
    private final StringBuilder stdoutBuilder = new StringBuilder();
    private final StringBuilder stderrBuilder = new StringBuilder();
    private Pattern okayErrorPattern = null;
    private Pattern okayStdOutPattern = null;

    public final Reader getStandardOutput() {
        return new CharSequenceReader((CharSequence)this.stdoutBuilder);
    }

    public final Reader getErrorOutput() {
        return new CharSequenceReader((CharSequence)this.stderrBuilder);
    }

    public boolean failOnNonZeroExit() {
        boolean stderrorNotOK;
        if (this.okayErrorPattern == null) {
            if (this.okayStdOutPattern == null) {
                return true;
            }
            return !this.okayStdOutPattern.matcher(this.stdoutBuilder.toString()).matches();
        }
        boolean bl = stderrorNotOK = !this.okayErrorPattern.matcher(this.stderrBuilder.toString()).matches();
        if (this.okayStdOutPattern == null) {
            return stderrorNotOK;
        }
        return !this.okayStdOutPattern.matcher(this.stdoutBuilder.toString()).matches();
    }

    public void setOkayErrorPattern(Pattern pattern) {
        this.okayErrorPattern = pattern;
    }

    public void setOkayStdOutPattern(Pattern pattern) {
        this.okayStdOutPattern = pattern;
    }

    public String handlePasswordFile(String configuredPasswordFile) throws AsAdminException {
        return configuredPasswordFile;
    }

    final void appendStandardOutputLine(String line) {
        this.stdoutBuilder.append(line).append("\n");
    }

    final void appendErrorOutputLine(String line) {
        this.stderrBuilder.append(line).append("\n");
    }
}

