/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1694", priority=Priority.MAJOR, tags={"convention"})
public class AbstractClassWithoutAbstractMethodCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1694";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1694");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol typeSymbol;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && (typeSymbol = ((ClassTreeImpl)tree).getSymbol()) != null && typeSymbol.isAbstract()) {
            Collection symbols = typeSymbol.members().scopeSymbols();
            int abstractMethod = this.countAbstractMethods(symbols);
            if (symbols.size() == 1 || abstractMethod == symbols.size() - 1) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Convert this \"" + typeSymbol + "\" class to an interface");
            }
            if (symbols.size() > 1 && abstractMethod == 0) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Convert this \"" + typeSymbol + "\" class to a concrete class with a private constructor");
            }
        }
        super.visitClass(tree);
    }

    private int countAbstractMethods(Collection<Symbol> symbols) {
        int abstractMethod = 0;
        for (Symbol sym : symbols) {
            if ("this".equals(sym.getName()) || !this.isAbstractMethod(sym)) continue;
            ++abstractMethod;
        }
        return abstractMethod;
    }

    private boolean isAbstractMethod(Symbol sym) {
        return sym.isKind(16) && sym.isAbstract();
    }
}

