/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2094", priority=Priority.MAJOR, tags={})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EmptyClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.isEmptyClass((ClassTree)tree)) {
            this.addIssue(tree, "Remove this empty class, write its code or make it an \"interface\".");
        }
    }

    private boolean isEmptyClass(ClassTree tree) {
        return tree.simpleName() != null && this.isNotExtending(tree) && tree.members().isEmpty();
    }

    private boolean isNotExtending(ClassTree tree) {
        return tree.superClass() == null && tree.superInterfaces().isEmpty();
    }
}

