/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1850", priority=Priority.MAJOR, tags={"bug", "cwe"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class InstanceOfAlwaysTrueCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INSTANCE_OF);
    }

    public void visitNode(Tree tree) {
        Type instanceOf;
        InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
        Type type = ((AbstractTypedTree)instanceOfTree.expression()).getSymbolType();
        if (this.typeInherits(type, instanceOf = ((AbstractTypedTree)instanceOfTree.type()).getSymbolType())) {
            this.addIssue(tree, "Remove this useless \"instanceof\" operator; it will always return \"true\". ");
        }
    }

    private boolean typeInherits(Type type, Type instanceOf) {
        if (type.isTagged(11) && instanceOf.isTagged(11)) {
            return this.typeInherits(((Type.ArrayType)type).elementType(), ((Type.ArrayType)instanceOf).elementType());
        }
        if (type.isTagged(10) && instanceOf.isTagged(10)) {
            Type.ClassType expressionType = (Type.ClassType)type;
            Type.ClassType instanceOfType = (Type.ClassType)instanceOf;
            return expressionType == instanceOfType || expressionType.getSymbol().superTypes().contains(instanceOfType);
        }
        return false;
    }
}

