/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.java.resolve.Types;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1905", priority=Priority.MINOR, tags={})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class RedundantTypeCastCheck
extends SubscriptionBaseVisitor {
    private Set<Tree> excluded = Sets.newHashSet();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_CAST, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            for (ExpressionTree arg : mit.arguments()) {
                if (!arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) continue;
                this.excluded.add((Tree)arg);
            }
        } else if (!this.excluded.contains(tree)) {
            TypeCastTree typeCastTree = (TypeCastTree)tree;
            Type cast = ((AbstractTypedTree)typeCastTree.type()).getSymbolType();
            Type expressionType = ((AbstractTypedTree)typeCastTree.expression()).getSymbolType();
            if (!cast.isParametrized() && new Types().isSubtype(expressionType, cast)) {
                this.addIssue(tree, "Remove this unnecessary cast to \"" + cast + "\".");
            }
        }
    }
}

