/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S135", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SeveralBreakOrContinuePerLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S135";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S135");
    private final Deque<Integer> breakAndContinueCounter = new ArrayDeque<Integer>();
    private final Deque<Boolean> currentScopeIsSwitch = new ArrayDeque<Boolean>();
    private int loopCount;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopCount = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitForStatement(ForStatementTree tree) {
        this.enterLoop();
        super.visitForStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.enterLoop();
        super.visitForEachStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterLoop();
        super.visitWhileStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterLoop();
        super.visitDoWhileStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        if (this.isInLoop() && !this.isInSwitch()) {
            this.incrementBreakCounter();
        }
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        if (this.isInLoop()) {
            this.incrementBreakCounter();
        }
        super.visitContinueStatement(tree);
    }

    private boolean isInLoop() {
        return this.loopCount > 0;
    }

    private boolean isInSwitch() {
        return this.currentScopeIsSwitch.peek();
    }

    private void incrementBreakCounter() {
        int increment = 1;
        if (!this.breakAndContinueCounter.isEmpty()) {
            increment += this.breakAndContinueCounter.pop().intValue();
        }
        this.breakAndContinueCounter.push(increment);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.currentScopeIsSwitch.push(true);
        super.visitSwitchStatement(tree);
        this.currentScopeIsSwitch.pop();
    }

    private void enterLoop() {
        ++this.loopCount;
        this.breakAndContinueCounter.push(0);
        this.currentScopeIsSwitch.push(false);
    }

    private void leaveLoop(Tree tree) {
        int count = 0;
        if (!this.breakAndContinueCounter.isEmpty()) {
            count = this.breakAndContinueCounter.pop();
        }
        if (count > 1) {
            this.context.addIssue(tree, this.ruleKey, "Reduce the total number of break and continue statement in this loop to use at most one.");
        }
        --this.loopCount;
        this.currentScopeIsSwitch.pop();
    }
}

