/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.InternalSyntaxTrivia;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="TrailingCommentCheck", priority=Priority.MINOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class TrailingCommentCheck
extends SubscriptionBaseVisitor {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^\\s*+[^\\s]++$";
    private static final Set<String> EXCLUDED_PATTERNS = ImmutableSet.of((Object)"NOSONAR", (Object)"NOPMD", (Object)"CHECKSTYLE:");
    @RuleProperty(key="legalCommentPattern", defaultValue="^\\s*+[^\\s]++$")
    public String legalCommentPattern = "^\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
        super.scanFile(context);
    }

    public void visitToken(SyntaxToken syntaxToken) {
        int tokenLine = ((InternalSyntaxToken)syntaxToken).getLine();
        if (tokenLine != this.previousTokenLine) {
            for (SyntaxTrivia trivia : syntaxToken.trivias()) {
                if (((InternalSyntaxTrivia)trivia).getLine() != this.previousTokenLine) continue;
                String comment = trivia.comment();
                String string = comment = comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
                if (this.pattern.matcher(comment = comment.trim()).matches() || this.containsExcludedPattern(comment)) continue;
                this.addIssue(this.previousTokenLine, "Move this trailing comment on the previous empty line.");
            }
        }
        this.previousTokenLine = tokenLine;
    }

    private boolean containsExcludedPattern(String comment) {
        for (String excludePattern : EXCLUDED_PATTERNS) {
            if (!StringUtils.containsIgnoreCase((String)comment, (String)excludePattern)) continue;
            return true;
        }
        return false;
    }
}

