/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1314", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class OctalValuesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1314";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1314");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && OctalValuesCheck.isOctal(tree.value())) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Use decimal values instead of octal ones.");
        }
    }

    private static boolean isOctal(String value) {
        return value.startsWith("0") && !"0".equals(value) && !OctalValuesCheck.isHexadecimal(value) && !OctalValuesCheck.isBinary(value);
    }

    private static boolean isHexadecimal(String value) {
        return value.startsWith("0x") || value.startsWith("0X");
    }

    private static boolean isBinary(String value) {
        return value.startsWith("0b") || value.startsWith("0B");
    }
}

