/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.java.resolve.Types;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1905", priority=Priority.MINOR, tags={})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class RedundantTypeCastCheck
extends SubscriptionBaseVisitor {
    private Set<Tree> excluded = Sets.newHashSet();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TYPE_CAST, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
            this.addArgsToExclusion(tree);
        } else if (!this.excluded.contains(tree)) {
            TypeCastTree typeCastTree = (TypeCastTree)tree;
            Type cast = ((AbstractTypedTree)typeCastTree.type()).getSymbolType();
            Type expressionType = ((AbstractTypedTree)typeCastTree.expression()).getSymbolType();
            Types types = new Types();
            if (!this.isExcluded(cast, expressionType) && (this.isRedundantNumericalCast(cast, expressionType) || this.isRedundantCast(cast, expressionType, types))) {
                this.addIssue(tree, "Remove this unnecessary cast to \"" + cast + "\".");
            }
        }
    }

    private void addArgsToExclusion(Tree tree) {
        List args;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            args = mit.arguments();
        } else {
            NewClassTree newClassTree = (NewClassTree)tree;
            args = newClassTree.arguments();
        }
        for (ExpressionTree arg : args) {
            if (!arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) continue;
            this.excluded.add((Tree)arg);
        }
    }

    private boolean isExcluded(Type cast, Type expressionType) {
        return cast.isTagged(14);
    }

    private boolean isRedundantCast(Type cast, Type expressionType, Types types) {
        return !cast.isNumerical() && !cast.isParametrized() && types.isSubtype(expressionType, cast);
    }

    private boolean isRedundantNumericalCast(Type cast, Type expressionType) {
        return cast.isNumerical() && cast == expressionType;
    }
}

