/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractMethodDetection
extends SubscriptionBaseVisitor {
    private List<MethodInvocationMatcher> matchers;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            for (MethodInvocationMatcher invocationMatcher : this.matchers()) {
                if (!invocationMatcher.matches(mit, this.getSemanticModel())) continue;
                this.onMethodFound(mit);
            }
        }
    }

    protected abstract List<MethodInvocationMatcher> getMethodInvocationMatchers();

    protected void onMethodFound(MethodInvocationTree mit) {
    }

    private List<MethodInvocationMatcher> matchers() {
        if (this.matchers == null) {
            this.matchers = this.getMethodInvocationMatchers();
        }
        return this.matchers;
    }
}

