/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class MethodInvocationMatcher {
    private TypeCriteria typeDefinition;
    private TypeCriteria callSite;
    private String methodName;
    private List<String> parameterTypes = Lists.newArrayList();

    MethodInvocationMatcher() {
    }

    public static MethodInvocationMatcher create() {
        return new MethodInvocationMatcher();
    }

    public MethodInvocationMatcher name(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public MethodInvocationMatcher typeDefinition(TypeCriteria typeDefinition) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = typeDefinition;
        return this;
    }

    public MethodInvocationMatcher typeDefinition(String fullyQualifiedTypeName) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = TypeCriteria.is(fullyQualifiedTypeName);
        return this;
    }

    public MethodInvocationMatcher callSite(TypeCriteria callSite) {
        this.callSite = callSite;
        return this;
    }

    public MethodInvocationMatcher addParameter(String fullyQualifiedTypeParameterName) {
        Preconditions.checkState((this.parameterTypes != null ? 1 : 0) != 0);
        this.parameterTypes.add(fullyQualifiedTypeParameterName);
        return this;
    }

    public MethodInvocationMatcher withNoParameterConstraint() {
        Preconditions.checkState((this.parameterTypes == null || this.parameterTypes.isEmpty() ? 1 : 0) != 0);
        this.parameterTypes = null;
        return this;
    }

    public boolean matches(MethodInvocationTree mit, SemanticModel semanticModel) {
        Type callSiteType;
        Symbol.MethodSymbol methodSymbol;
        Symbol symbol;
        IdentifierTree id = this.getIdentifier(mit);
        return id != null && (symbol = semanticModel.getReference(id)) != null && symbol.isKind(16) && this.isSearchedMethod(methodSymbol = (Symbol.MethodSymbol)symbol, callSiteType = this.getCallSiteType(mit, semanticModel));
    }

    private Type getCallSiteType(MethodInvocationTree mit, SemanticModel semanticModel) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return semanticModel.getEnclosingClass((Tree)mit).getType();
        }
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree methodSelect = (MemberSelectExpressionTree)mit.methodSelect();
            return ((AbstractTypedTree)methodSelect.expression()).getSymbolType();
        }
        return null;
    }

    private boolean isSearchedMethod(Symbol.MethodSymbol symbol, Type callSiteType) {
        boolean result;
        boolean bl = result = symbol.getName().equals(this.methodName) && this.parametersAcceptable(symbol);
        if (this.typeDefinition != null) {
            result &= this.typeDefinition.matches(symbol.owner().getType());
        }
        if (this.callSite != null) {
            result &= this.callSite.matches(callSiteType);
        }
        return result;
    }

    private boolean parametersAcceptable(Symbol.MethodSymbol methodSymbol) {
        if (this.parameterTypes == null) {
            return true;
        }
        List parametersTypes = methodSymbol.getParametersTypes();
        List<String> arguments = this.parameterTypes;
        if (parametersTypes.size() == arguments.size()) {
            int i = 0;
            for (Type parameterType : parametersTypes) {
                if (!parameterType.is(arguments.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = null;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            id = (IdentifierTree)mit.methodSelect();
        } else if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            id = ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        }
        return id;
    }
}

