/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.impl.ast.AstXmlPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KindMaps;
import org.sonar.java.model.expression.ArrayAccessExpressionTreeImpl;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.InstanceOfTreeImpl;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.model.expression.TypeCastExpressionTreeImpl;
import org.sonar.java.model.expression.UnaryExpressionTreeImpl;
import org.sonar.java.model.statement.AssertStatementTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.BreakStatementTreeImpl;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.java.model.statement.ContinueStatementTreeImpl;
import org.sonar.java.model.statement.DoWhileStatementTreeImpl;
import org.sonar.java.model.statement.EmptyStatementTreeImpl;
import org.sonar.java.model.statement.ExpressionStatementTreeImpl;
import org.sonar.java.model.statement.ForEachStatementImpl;
import org.sonar.java.model.statement.ForStatementTreeImpl;
import org.sonar.java.model.statement.IfStatementTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.model.statement.ReturnStatementTreeImpl;
import org.sonar.java.model.statement.SwitchStatementTreeImpl;
import org.sonar.java.model.statement.SynchronizedStatementTreeImpl;
import org.sonar.java.model.statement.ThrowStatementTreeImpl;
import org.sonar.java.model.statement.TryStatementTreeImpl;
import org.sonar.java.model.statement.WhileStatementTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class JavaTreeMaker {
    private final KindMaps kindMaps = new KindMaps();

    private static void checkType(AstNode astNode, AstNodeType ... expected) {
        Preconditions.checkArgument((boolean)astNode.is(expected), (String)"Unexpected AstNodeType: %s", (Object[])new Object[]{astNode.getType().toString()});
    }

    private IdentifierTree identifier(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaTokenType.IDENTIFIER, JavaKeyword.THIS, JavaKeyword.CLASS, JavaKeyword.SUPER});
        return new IdentifierTreeImpl(astNode, astNode.getTokenValue());
    }

    private ExpressionTree qualifiedIdentifier(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        List identifierNodes = astNode.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        Object result = this.identifier((AstNode)identifierNodes.get(0));
        for (int i = 1; i < identifierNodes.size(); ++i) {
            result = new MemberSelectExpressionTreeImpl((AstNode)identifierNodes.get(i), (ExpressionTree)result, this.identifier((AstNode)identifierNodes.get(i)));
        }
        return result;
    }

    private List<ExpressionTree> qualifiedIdentifierList(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER_LIST});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode qualifiedIdentifierNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER})) {
            result.add((Object)this.qualifiedIdentifier(qualifiedIdentifierNode));
        }
        return result.build();
    }

    @VisibleForTesting
    LiteralTree literal(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.LITERAL});
        AstNode childNode = astNode.getFirstChild();
        return new LiteralTreeImpl(childNode, this.kindMaps.getLiteral(childNode.getType()));
    }

    @VisibleForTesting
    PrimitiveTypeTree basicType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.BASIC_TYPE, JavaKeyword.VOID});
        return new JavaTree.PrimitiveTypeTreeImpl(astNode);
    }

    private ExpressionTree classType(AstNode astNode) {
        AstNode child;
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.CLASS_TYPE, JavaGrammar.CREATED_NAME});
        AstNode firstIdentifier = child = astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        Object result = this.identifier(child);
        for (int i = 1; i < astNode.getNumberOfChildren(); ++i) {
            child = astNode.getChild(i);
            if (child.is(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
                if (child.equals(firstIdentifier)) continue;
                result = new MemberSelectExpressionTreeImpl(child, (ExpressionTree)result, this.identifier(child));
                continue;
            }
            if (child.is(new AstNodeType[]{JavaGrammar.TYPE_ARGUMENTS})) {
                result = new JavaTree.ParameterizedTypeTreeImpl(child, (ExpressionTree)result, this.typeArguments(child));
                continue;
            }
            if (child.is(new AstNodeType[]{JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS})) {
                result = new JavaTree.ParameterizedTypeTreeImpl(child, (ExpressionTree)result, this.nonWildcardTypeArguments(child));
                continue;
            }
            if (child.is(new AstNodeType[]{JavaPunctuator.DOT}) || child.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) continue;
            throw new IllegalStateException("Unexpected AstNodeType: " + astNode.getType().toString() + " at line " + astNode.getTokenLine() + " column " + astNode.getToken().getColumn());
        }
        return result;
    }

    @VisibleForTesting
    List<Tree> typeArguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.TYPE_ARGUMENTS});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode child : astNode.getChildren(new AstNodeType[]{JavaGrammar.TYPE_ARGUMENT})) {
            Object typeArgument;
            AstNode referenceTypeNode = child.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE});
            ExpressionTree expressionTree = typeArgument = referenceTypeNode != null ? this.referenceType(referenceTypeNode) : null;
            if (child.hasDirectChildren(new AstNodeType[]{JavaPunctuator.QUERY})) {
                Tree.Kind kind = child.hasDirectChildren(new AstNodeType[]{JavaKeyword.EXTENDS}) ? Tree.Kind.EXTENDS_WILDCARD : (child.hasDirectChildren(new AstNodeType[]{JavaKeyword.SUPER}) ? Tree.Kind.SUPER_WILDCARD : Tree.Kind.UNBOUNDED_WILDCARD);
                typeArgument = new JavaTree.WildcardTreeImpl(child, kind, (Tree)typeArgument);
            }
            result.add(typeArgument);
        }
        return result.build();
    }

    private List<Tree> nonWildcardTypeArguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode child : astNode.getChildren(new AstNodeType[]{JavaGrammar.TYPE})) {
            result.add((Object)this.referenceType(child));
        }
        return result.build();
    }

    @VisibleForTesting
    ExpressionTree referenceType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.TYPE});
        PrimitiveTypeTree result = astNode.getFirstChild().is(new AstNodeType[]{JavaGrammar.BASIC_TYPE}) ? this.basicType(astNode.getFirstChild()) : this.classType(astNode.getFirstChild());
        return this.applyDim((ExpressionTree)result, astNode.getChildren(new AstNodeType[]{JavaGrammar.DIM}).size());
    }

    private ModifiersTree modifiers(List<AstNode> modifierNodes) {
        if (modifierNodes.isEmpty()) {
            return JavaTree.ModifiersTreeImpl.EMPTY;
        }
        ImmutableList.Builder modifiers = ImmutableList.builder();
        ImmutableList.Builder annotations = ImmutableList.builder();
        for (AstNode astNode : modifierNodes) {
            Preconditions.checkArgument((boolean)astNode.is(new AstNodeType[]{JavaGrammar.MODIFIER}), (String)"Unexpected AstNodeType: %s", (Object[])new Object[]{astNode.getType().toString()});
            astNode = astNode.getFirstChild();
            if (astNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
                annotations.add((Object)this.annotation(astNode));
                continue;
            }
            JavaKeyword keyword = (JavaKeyword)astNode.getType();
            modifiers.add((Object)this.kindMaps.getModifier(keyword));
        }
        return new JavaTree.ModifiersTreeImpl(modifierNodes.get(0), (List<Modifier>)modifiers.build(), (List<AnnotationTree>)annotations.build());
    }

    private AnnotationTree annotation(AstNode astNode) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        ExpressionTree annotationType = this.qualifiedIdentifier(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ANNOTATION_REST})) {
            AstNode elementValuePairs;
            AstNode annotationRest = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION_REST}).getFirstChild();
            if (annotationRest.is(new AstNodeType[]{JavaGrammar.SINGLE_ELEMENT_ANNOTATION_REST})) {
                arguments.add((Object)this.elementValue(annotationRest.getFirstChild(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE})));
            } else if (annotationRest.is(new AstNodeType[]{JavaGrammar.NORMAL_ANNOTATION_REST}) && (elementValuePairs = annotationRest.getFirstChild(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_PAIRS})) != null) {
                List values = elementValuePairs.getChildren(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_PAIR});
                for (AstNode value : values) {
                    AstNode identifier = value.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
                    arguments.add((Object)new AssignmentExpressionTreeImpl(value, (ExpressionTree)this.identifier(identifier), this.kindMaps.getAssignmentOperator(JavaPunctuator.EQU), this.elementValue(value.getFirstChild(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE}))));
                }
            }
        }
        return new JavaTree.AnnotationTreeImpl(astNode, (Tree)annotationType, (List<ExpressionTree>)arguments.build());
    }

    private ExpressionTree elementValue(AstNode astNode) {
        Object result;
        AstNode elementValue = astNode.getFirstChild();
        if (elementValue.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
            result = this.annotation(elementValue);
        } else if (elementValue.is(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_ARRAY_INITIALIZER})) {
            ArrayList elementValues = Lists.newArrayList();
            if (elementValue.hasDirectChildren(new AstNodeType[]{JavaGrammar.ELEMENT_VALUES})) {
                AstNode elementValuesNode = elementValue.getFirstChild(new AstNodeType[]{JavaGrammar.ELEMENT_VALUES});
                for (AstNode node : elementValuesNode.getChildren(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE})) {
                    elementValues.add(this.elementValue(node));
                }
            }
            result = new NewArrayTreeImpl(elementValue, null, (List<ExpressionTree>)ImmutableList.of(), elementValues);
        } else {
            result = this.expression(elementValue);
        }
        return result;
    }

    private VariableTree variableDeclarator(ModifiersTree modifiers, ExpressionTree type, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR});
        return new JavaTree.VariableTreeImpl(astNode, modifiers, (Tree)this.applyDim(type, astNode.getChildren(new AstNodeType[]{JavaGrammar.DIM}).size()), this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.VARIABLE_INITIALIZER}) ? this.variableInitializer(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_INITIALIZER})) : null);
    }

    private List<StatementTree> variableDeclarators(ModifiersTree modifiers, ExpressionTree type, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode variableDeclaratorNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
            result.add((Object)this.variableDeclarator(modifiers, type, variableDeclaratorNode));
        }
        return result.build();
    }

    public CompilationUnitTree compilationUnit(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.COMPILATION_UNIT});
        ImmutableList.Builder imports = ImmutableList.builder();
        for (AstNode importNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.IMPORT_DECLARATION})) {
            AstNode astNodeQualifiedIdentifier = importNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
            Object qualifiedIdentifier = this.qualifiedIdentifier(astNodeQualifiedIdentifier);
            if (astNodeQualifiedIdentifier.getNextSibling().is(new AstNodeType[]{JavaPunctuator.DOT}) && astNodeQualifiedIdentifier.getNextSibling().getNextSibling().is(new AstNodeType[]{JavaPunctuator.STAR})) {
                qualifiedIdentifier = new MemberSelectExpressionTreeImpl(astNodeQualifiedIdentifier.getNextSibling().getNextSibling(), (ExpressionTree)qualifiedIdentifier, new IdentifierTreeImpl(astNodeQualifiedIdentifier.getNextSibling().getNextSibling(), JavaPunctuator.STAR.getValue()));
            }
            imports.add((Object)new JavaTree.ImportTreeImpl(importNode, importNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC}), (Tree)qualifiedIdentifier));
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (AstNode typeNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.TYPE_DECLARATION})) {
            AstNode declarationNode = typeNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
            if (declarationNode == null) continue;
            types.add((Object)this.typeDeclaration(this.modifiers(typeNode.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})), declarationNode));
        }
        ExpressionTree packageDeclaration = null;
        ImmutableList.Builder packageAnnotations = ImmutableList.builder();
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION})) {
            AstNode packageDeclarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION});
            packageDeclaration = this.qualifiedIdentifier(packageDeclarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
            for (AstNode annotationNode : packageDeclarationNode.getChildren(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
                packageAnnotations.add((Object)this.annotation(annotationNode));
            }
        }
        return new JavaTree.CompilationUnitTreeImpl(astNode, packageDeclaration, (List<ImportTree>)imports.build(), (List<Tree>)types.build(), (List<AnnotationTree>)packageAnnotations.build());
    }

    private ClassTree typeDeclaration(ModifiersTree modifiers, AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION})) {
            return this.classDeclaration(modifiers, astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.ENUM_DECLARATION})) {
            return this.enumDeclaration(modifiers, astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION})) {
            return this.interfaceDeclaration(modifiers, astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_DECLARATION})) {
            return this.annotationTypeDeclaration(modifiers, astNode);
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType().toString());
    }

    private ClassTree classDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.CLASS_DECLARATION});
        IdentifierTree simpleName = this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        AstNode extendsNode = astNode.getFirstChild(new AstNodeType[]{JavaKeyword.EXTENDS});
        ExpressionTree superClass = extendsNode != null ? this.classType(extendsNode.getNextSibling()) : null;
        AstNode implementsNode = astNode.getFirstChild(new AstNodeType[]{JavaKeyword.IMPLEMENTS});
        ImmutableList superInterfaces = implementsNode != null ? this.classTypeList(implementsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.CLASS, modifiers, simpleName, (Tree)superClass, (List<Tree>)superInterfaces, this.classBody(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_BODY})));
    }

    private List<Tree> classTypeList(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.CLASS_TYPE_LIST});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode classTypeNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.CLASS_TYPE})) {
            result.add((Object)this.classType(classTypeNode));
        }
        return result.build();
    }

    private List<Tree> classBody(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.CLASS_BODY, JavaGrammar.ENUM_BODY_DECLARATIONS});
        ImmutableList.Builder members = ImmutableList.builder();
        for (AstNode classBodyDeclaration : astNode.getChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            ModifiersTree modifiers = this.modifiers(classBodyDeclaration.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER}));
            if (classBodyDeclaration.hasDirectChildren(new AstNodeType[]{JavaGrammar.MEMBER_DECL})) {
                AstNode memberDeclNode = classBodyDeclaration.getFirstChild(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
                if (memberDeclNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION})) {
                    members.addAll(this.fieldDeclaration(modifiers, memberDeclNode.getFirstChild(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION})));
                    continue;
                }
                members.add((Object)this.memberDeclaration(modifiers, memberDeclNode));
                continue;
            }
            if (!classBodyDeclaration.getFirstChild().is(new AstNodeType[]{JavaGrammar.CLASS_INIT_DECLARATION})) continue;
            AstNode classInitDeclarationNode = classBodyDeclaration.getFirstChild();
            members.add((Object)new BlockTreeImpl(classInitDeclarationNode, classInitDeclarationNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC}) ? Tree.Kind.STATIC_INITIALIZER : Tree.Kind.INITIALIZER, this.blockStatements(classInitDeclarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}))));
        }
        return members.build();
    }

    private Tree memberDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.MEMBER_DECL});
        AstNode declaration = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
        if (declaration != null) {
            return this.typeDeclaration(modifiers, declaration);
        }
        declaration = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST});
        if (declaration != null) {
            return this.methodDeclarator(modifiers, declaration.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE, JavaKeyword.VOID}), declaration.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), declaration.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST}));
        }
        declaration = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST});
        if (declaration != null) {
            return this.methodDeclarator(modifiers, astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE, JavaKeyword.VOID}), astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), declaration);
        }
        throw new IllegalStateException();
    }

    private List<StatementTree> fieldDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.FIELD_DECLARATION});
        return this.variableDeclarators(modifiers, this.referenceType(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE})), astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}));
    }

    private MethodTree methodDeclarator(ModifiersTree modifiers, @Nullable AstNode returnTypeNode, AstNode name, AstNode astNode) {
        JavaTreeMaker.checkType(name, new AstNodeType[]{JavaTokenType.IDENTIFIER});
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST});
        Object returnType = null;
        if (returnTypeNode != null) {
            returnType = returnTypeNode.is(new AstNodeType[]{JavaKeyword.VOID}) ? this.basicType(returnTypeNode) : this.referenceType(returnTypeNode);
        }
        BlockTree body = null;
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.METHOD_BODY})) {
            body = this.block(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_BODY}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}));
        }
        AstNode throwsClauseNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER_LIST});
        return new JavaTree.MethodTreeImpl(astNode, modifiers, (Tree)returnType, this.identifier(name), this.formalParameters(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS})), body, (List<ExpressionTree>)(throwsClauseNode != null ? this.qualifiedIdentifierList(throwsClauseNode) : ImmutableList.of()), null);
    }

    private List<VariableTree> formalParameters(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode variableDeclaratorIdNode : astNode.getDescendants(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID})) {
            AstNode typeNode = variableDeclaratorIdNode.getPreviousAstNode();
            AstNode referenceTypeNode = typeNode.getPreviousAstNode();
            while (referenceTypeNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
                referenceTypeNode = referenceTypeNode.getPreviousAstNode();
            }
            JavaTree.ArrayTypeTreeImpl type = typeNode.is(new AstNodeType[]{JavaPunctuator.ELLIPSIS}) ? new JavaTree.ArrayTypeTreeImpl(typeNode, (Tree)this.referenceType(referenceTypeNode)) : this.referenceType(typeNode);
            result.add((Object)new JavaTree.VariableTreeImpl(variableDeclaratorIdNode, JavaTree.ModifiersTreeImpl.EMPTY, type, this.identifier(variableDeclaratorIdNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), null));
        }
        return result.build();
    }

    private ClassTree enumDeclaration(ModifiersTree modifiers, AstNode astNode) {
        AstNode implementsNode;
        AstNode enumBodyDeclarationsNode;
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.ENUM_DECLARATION});
        IdentifierTree enumType = this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        ImmutableList.Builder members = ImmutableList.builder();
        AstNode enumBodyNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ENUM_BODY});
        AstNode enumConstantsNode = enumBodyNode.getFirstChild(new AstNodeType[]{JavaGrammar.ENUM_CONSTANTS});
        if (enumConstantsNode != null) {
            for (AstNode enumConstantNode : enumConstantsNode.getChildren(new AstNodeType[]{JavaGrammar.ENUM_CONSTANT})) {
                AstNode argumentsNode = enumConstantNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS});
                AstNode classBodyNode = enumConstantNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_BODY});
                IdentifierTree enumIdentifier = this.identifier(enumConstantNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
                members.add((Object)new JavaTree.EnumConstantTreeImpl(enumConstantNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)enumType, enumIdentifier, (ExpressionTree)new NewClassTreeImpl(enumConstantNode, null, (ExpressionTree)enumIdentifier, (List<ExpressionTree>)(argumentsNode != null ? this.arguments(argumentsNode) : ImmutableList.of()), classBodyNode == null ? null : new JavaTree.ClassTreeImpl(classBodyNode, Tree.Kind.CLASS, JavaTree.ModifiersTreeImpl.EMPTY, this.classBody(classBodyNode)))));
            }
        }
        if ((enumBodyDeclarationsNode = enumBodyNode.getFirstChild(new AstNodeType[]{JavaGrammar.ENUM_BODY_DECLARATIONS})) != null) {
            members.addAll(this.classBody(enumBodyDeclarationsNode));
        }
        ImmutableList superInterfaces = (implementsNode = astNode.getFirstChild(new AstNodeType[]{JavaKeyword.IMPLEMENTS})) != null ? this.classTypeList(implementsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.ENUM, modifiers, enumType, null, (List<Tree>)superInterfaces, (List<Tree>)members.build());
    }

    private ClassTree interfaceDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION});
        IdentifierTree simpleName = this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        ImmutableList.Builder members = ImmutableList.builder();
        for (AstNode interfaceBodyDeclarationNode : astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_BODY}).getChildren(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION})) {
            ModifiersTree memberModifiers = this.modifiers(interfaceBodyDeclarationNode.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER}));
            AstNode interfaceMemberDeclNode = interfaceBodyDeclarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_MEMBER_DECL});
            if (interfaceMemberDeclNode == null) continue;
            this.appendInterfaceMember(memberModifiers, (ImmutableList.Builder<Tree>)members, interfaceMemberDeclNode);
        }
        AstNode extendsNode = astNode.getFirstChild(new AstNodeType[]{JavaKeyword.EXTENDS});
        ImmutableList superInterfaces = extendsNode != null ? this.classTypeList(extendsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.INTERFACE, modifiers, simpleName, null, (List<Tree>)superInterfaces, (List<Tree>)members.build());
    }

    private void appendInterfaceMember(ModifiersTree modifiers, ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.INTERFACE_MEMBER_DECL});
        AstNode declarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
        if (declarationNode != null) {
            members.add((Object)this.typeDeclaration(modifiers, declarationNode));
            return;
        }
        declarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL});
        if (declarationNode != null) {
            AstNode interfaceMethodOrFieldRestNode = declarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_REST});
            AstNode interfaceMethodDeclaratorRestNode = interfaceMethodOrFieldRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST});
            if (interfaceMethodDeclaratorRestNode != null) {
                members.add((Object)this.methodDeclarator(modifiers, declarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE, JavaKeyword.VOID}), declarationNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), interfaceMethodDeclaratorRestNode));
                return;
            }
            this.appendConstantDeclarations(modifiers, members, declarationNode);
            return;
        }
        declarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_GENERIC_METHOD_DECL});
        if (declarationNode != null) {
            members.add((Object)this.methodDeclarator(modifiers, declarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE, JavaKeyword.VOID}), declarationNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), declarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST})));
            return;
        }
        declarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST});
        if (declarationNode != null) {
            members.add((Object)this.methodDeclarator(modifiers, astNode.getFirstChild(new AstNodeType[]{JavaKeyword.VOID}), astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), declarationNode));
            return;
        }
        throw new IllegalStateException();
    }

    private void appendConstantDeclarations(ModifiersTree modifiers, ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL, JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST});
        ExpressionTree type = this.referenceType(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE, JavaKeyword.VOID}));
        for (AstNode constantDeclaratorRestNode : astNode.getDescendants(new AstNodeType[]{JavaGrammar.CONSTANT_DECLARATOR_REST})) {
            AstNode identifierNode = constantDeclaratorRestNode.getPreviousAstNode();
            Preconditions.checkState((boolean)identifierNode.is(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
            members.add((Object)new JavaTree.VariableTreeImpl(constantDeclaratorRestNode, modifiers, (Tree)this.applyDim(type, constantDeclaratorRestNode.getChildren(new AstNodeType[]{JavaGrammar.DIM}).size()), this.identifier(identifierNode), this.variableInitializer(constantDeclaratorRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_INITIALIZER}))));
        }
    }

    private ClassTree annotationTypeDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_DECLARATION});
        IdentifierTree simpleName = this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        ImmutableList.Builder members = ImmutableList.builder();
        for (AstNode annotationTypeElementDeclarationNode : astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_BODY}).getChildren(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION})) {
            AstNode annotationTypeElementRestNode = annotationTypeElementDeclarationNode.getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST});
            if (annotationTypeElementRestNode == null) continue;
            this.appendAnnotationTypeElementDeclaration((ImmutableList.Builder<Tree>)members, annotationTypeElementRestNode);
        }
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.ANNOTATION_TYPE, modifiers, simpleName, null, (List<Tree>)ImmutableList.of(), (List<Tree>)members.build());
    }

    private void appendAnnotationTypeElementDeclaration(ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST});
        AstNode declarationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
        if (declarationNode != null) {
            members.add((Object)this.typeDeclaration(JavaTree.ModifiersTreeImpl.EMPTY, declarationNode));
            return;
        }
        AstNode typeNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE});
        AstNode identifierNode = astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        AstNode annotationMethodRestNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION_METHOD_OR_CONSTANT_REST}).getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION_METHOD_REST});
        if (annotationMethodRestNode != null) {
            members.add((Object)new JavaTree.MethodTreeImpl(annotationMethodRestNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.referenceType(typeNode), this.identifier(identifierNode), (List<VariableTree>)ImmutableList.of(), null, (List<ExpressionTree>)ImmutableList.of(), null));
        } else {
            this.appendConstantDeclarations(JavaTree.ModifiersTreeImpl.EMPTY, members, astNode);
        }
    }

    @VisibleForTesting
    BlockTree block(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.BLOCK});
        return new BlockTreeImpl(astNode, Tree.Kind.BLOCK, this.blockStatements(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS})));
    }

    private List<StatementTree> blockStatements(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS});
        ImmutableList.Builder statements = ImmutableList.builder();
        for (AstNode blockStatementNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT})) {
            AstNode statementNode = blockStatementNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT, JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION});
            if (statementNode.is(new AstNodeType[]{JavaGrammar.STATEMENT})) {
                statements.add((Object)this.statement(statementNode));
                continue;
            }
            if (statementNode.is(new AstNodeType[]{JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT})) {
                statements.addAll(this.variableDeclarators(this.variableModifiers(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_MODIFIERS})), this.referenceType(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE})), statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS})));
                continue;
            }
            if (statementNode.is(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION})) {
                statements.add((Object)this.classDeclaration(this.modifiers(blockStatementNode.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})), statementNode));
                continue;
            }
            if (statementNode.is(new AstNodeType[]{JavaGrammar.ENUM_DECLARATION})) {
                statements.add((Object)this.enumDeclaration(this.modifiers(blockStatementNode.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})), statementNode));
                continue;
            }
            throw new IllegalStateException("Unexpected AstNodeType: " + statementNode.getType().toString());
        }
        return statements.build();
    }

    private ModifiersTree variableModifiers(@Nullable AstNode astNode) {
        if (astNode == null) {
            return JavaTree.ModifiersTreeImpl.EMPTY;
        }
        Preconditions.checkArgument((boolean)astNode.is(new AstNodeType[]{JavaGrammar.VARIABLE_MODIFIERS}), (String)"Unexpected AstNodeType: %s", (Object[])new Object[]{astNode.getType().toString()});
        ImmutableList.Builder modifiers = ImmutableList.builder();
        ImmutableList.Builder annotations = ImmutableList.builder();
        for (AstNode modifierAstNode : astNode.getChildren()) {
            if (modifierAstNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
                annotations.add((Object)this.annotation(modifierAstNode));
                continue;
            }
            JavaKeyword keyword = (JavaKeyword)modifierAstNode.getType();
            modifiers.add((Object)this.kindMaps.getModifier(keyword));
        }
        return new JavaTree.ModifiersTreeImpl(astNode, (List<Modifier>)modifiers.build(), (List<AnnotationTree>)annotations.build());
    }

    @VisibleForTesting
    StatementTree statement(AstNode astNode) {
        Object result;
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.STATEMENT});
        AstNode statementNode = astNode.getFirstChild();
        switch ((JavaGrammar)statementNode.getType()) {
            case BLOCK: {
                result = this.block(statementNode);
                break;
            }
            case EMPTY_STATEMENT: {
                result = new EmptyStatementTreeImpl(statementNode);
                break;
            }
            case LABELED_STATEMENT: {
                result = new LabeledStatementTreeImpl(statementNode, this.identifier(statementNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), this.statement(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT})));
                break;
            }
            case EXPRESSION_STATEMENT: {
                result = new ExpressionStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT_EXPRESSION})));
                break;
            }
            case IF_STATEMENT: {
                List statements = statementNode.getChildren(new AstNodeType[]{JavaGrammar.STATEMENT});
                result = new IfStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})), this.statement((AstNode)statements.get(0)), statements.size() > 1 ? this.statement((AstNode)statements.get(1)) : null);
                break;
            }
            case ASSERT_STATEMENT: {
                List expressions = statementNode.getChildren(new AstNodeType[]{JavaGrammar.EXPRESSION});
                result = new AssertStatementTreeImpl(statementNode, this.expression((AstNode)expressions.get(0)), expressions.size() > 1 ? this.expression((AstNode)expressions.get(1)) : null);
                break;
            }
            case SWITCH_STATEMENT: {
                result = this.switchStatement(statementNode);
                break;
            }
            case WHILE_STATEMENT: {
                result = new WhileStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})), this.statement(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT})));
                break;
            }
            case DO_STATEMENT: {
                result = new DoWhileStatementTreeImpl(statementNode, this.statement(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT})), this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})));
                break;
            }
            case FOR_STATEMENT: {
                result = this.forStatement(statementNode);
                break;
            }
            case BREAK_STATEMENT: {
                result = new BreakStatementTreeImpl(statementNode, statementNode.hasDirectChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER}) ? this.identifier(statementNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})) : null);
                break;
            }
            case CONTINUE_STATEMENT: {
                result = new ContinueStatementTreeImpl(statementNode, statementNode.hasDirectChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER}) ? this.identifier(statementNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})) : null);
                break;
            }
            case RETURN_STATEMENT: {
                result = new ReturnStatementTreeImpl(statementNode, statementNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION}) ? this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})) : null);
                break;
            }
            case THROW_STATEMENT: {
                result = new ThrowStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
                break;
            }
            case SYNCHRONIZED_STATEMENT: {
                result = new SynchronizedStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})), this.block(statementNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK})));
                break;
            }
            case TRY_STATEMENT: {
                result = this.tryStatement(statementNode);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected AstNodeType: " + astNode.getType().toString());
            }
        }
        return result;
    }

    private SwitchStatementTree switchStatement(AstNode astNode) {
        ImmutableList.Builder cases = ImmutableList.builder();
        ArrayList labels = Lists.newArrayList();
        for (AstNode caseNode : astNode.getFirstChild(new AstNodeType[]{JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS}).getChildren(new AstNodeType[]{JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP})) {
            AstNode expressionNode = caseNode.getFirstChild(new AstNodeType[]{JavaGrammar.SWITCH_LABEL}).getFirstChild(new AstNodeType[]{JavaGrammar.CONSTANT_EXPRESSION});
            AstNode blockStatementsNode = caseNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS});
            labels.add(new CaseLabelTreeImpl(caseNode, expressionNode != null ? this.expression(expressionNode) : null));
            if (!blockStatementsNode.hasChildren()) continue;
            cases.add((Object)new CaseGroupTreeImpl(((CaseLabelTreeImpl)labels.get(0)).getAstNode(), (List<CaseLabelTree>)ImmutableList.copyOf((Collection)labels), this.blockStatements(caseNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}))));
            labels.clear();
        }
        if (!labels.isEmpty()) {
            cases.add((Object)new CaseGroupTreeImpl(((CaseLabelTreeImpl)labels.get(0)).getAstNode(), (List<CaseLabelTree>)ImmutableList.copyOf((Collection)labels), (List<StatementTree>)ImmutableList.of()));
        }
        return new SwitchStatementTreeImpl(astNode, this.expression(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})), (List<CaseGroupTree>)cases.build());
    }

    private StatementTree forStatement(AstNode astNode) {
        AstNode formalParameterNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETER});
        if (formalParameterNode == null) {
            AstNode forInitNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FOR_INIT});
            Object forInit = forInitNode == null ? ImmutableList.of() : (forInitNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}) ? this.variableDeclarators(JavaTree.ModifiersTreeImpl.EMPTY, this.referenceType(forInitNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE})), forInitNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS})) : this.statementExpressions(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FOR_INIT})));
            return new ForStatementTreeImpl(astNode, (List<StatementTree>)forInit, astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION}) ? this.expression(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})) : null, (List<StatementTree>)(astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.FOR_UPDATE}) ? this.statementExpressions(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FOR_UPDATE})) : ImmutableList.of()), this.statement(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT})));
        }
        return new ForEachStatementImpl(astNode, new JavaTree.VariableTreeImpl(formalParameterNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.referenceType(formalParameterNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE})), this.identifier(formalParameterNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID}).getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), null), this.expression(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})), this.statement(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT})));
    }

    private List<StatementTree> statementExpressions(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.FOR_INIT, JavaGrammar.FOR_UPDATE});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode statementExpressionNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.STATEMENT_EXPRESSION})) {
            result.add((Object)new ExpressionStatementTreeImpl(statementExpressionNode, this.expression(statementExpressionNode)));
        }
        return result.build();
    }

    private TryStatementTree tryStatement(AstNode astNode) {
        AstNode resourceSpecificationNode;
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.TRY_WITH_RESOURCES_STATEMENT})) {
            astNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TRY_WITH_RESOURCES_STATEMENT});
        }
        ImmutableList.Builder catches = ImmutableList.builder();
        for (AstNode catchNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.CATCH_CLAUSE})) {
            AstNode catchFormalParameterNode = catchNode.getFirstChild(new AstNodeType[]{JavaGrammar.CATCH_FORMAL_PARAMETER});
            catches.add((Object)new CatchTreeImpl(catchNode, new JavaTree.VariableTreeImpl(catchFormalParameterNode, JavaTree.ModifiersTreeImpl.EMPTY, this.catchType(catchFormalParameterNode.getFirstChild(new AstNodeType[]{JavaGrammar.CATCH_TYPE})), this.identifier(catchFormalParameterNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID}).getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), null), this.block(catchNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}))));
        }
        BlockTree finallyBlock = null;
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.FINALLY_})) {
            finallyBlock = this.block(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.FINALLY_}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}));
        }
        return new TryStatementTreeImpl(astNode, (List<VariableTree>)((resourceSpecificationNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.RESOURCE_SPECIFICATION})) == null ? ImmutableList.of() : this.resourceSpecification(resourceSpecificationNode)), this.block(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK})), (List<CatchTree>)catches.build(), finallyBlock);
    }

    private Tree catchType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.CATCH_TYPE});
        List children = astNode.getChildren(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        if (children.size() == 1) {
            return this.qualifiedIdentifier((AstNode)children.get(0));
        }
        ImmutableList.Builder typeAlternatives = ImmutableList.builder();
        for (AstNode child : children) {
            typeAlternatives.add((Object)this.qualifiedIdentifier(child));
        }
        return new JavaTree.UnionTypeTreeImpl(astNode, (List<Tree>)typeAlternatives.build());
    }

    private List<VariableTree> resourceSpecification(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.RESOURCE_SPECIFICATION});
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode resourceNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.RESOURCE})) {
            result.add((Object)new JavaTree.VariableTreeImpl(resourceNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.classType(resourceNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE})), this.identifier(resourceNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID}).getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), this.expression(resourceNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION}))));
        }
        return result.build();
    }

    @VisibleForTesting
    ExpressionTree expression(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.CONSTANT_EXPRESSION, JavaGrammar.STATEMENT_EXPRESSION})) {
            astNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION}).getFirstChild();
        } else if (astNode.is(new AstNodeType[]{JavaGrammar.EXPRESSION})) {
            astNode = astNode.getFirstChild();
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})) {
            return new ParenthesizedTreeImpl(astNode, this.expression(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.PRIMARY})) {
            return this.primary(astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.CONDITIONAL_OR_EXPRESSION, JavaGrammar.CONDITIONAL_AND_EXPRESSION, JavaGrammar.INCLUSIVE_OR_EXPRESSION, JavaGrammar.EXCLUSIVE_OR_EXPRESSION, JavaGrammar.AND_EXPRESSION, JavaGrammar.EQUALITY_EXPRESSION, JavaGrammar.RELATIONAL_EXPRESSION, JavaGrammar.SHIFT_EXPRESSION, JavaGrammar.ADDITIVE_EXPRESSION, JavaGrammar.MULTIPLICATIVE_EXPRESSION})) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.CONDITIONAL_EXPRESSION})) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.ASSIGNMENT_EXPRESSION})) {
            return this.assignmentExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION, JavaGrammar.UNARY_EXPRESSION_NOT_PLUS_MINUS, JavaGrammar.CAST_EXPRESSION})) {
            return this.unaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.METHOD_REFERENCE})) {
            return new JavaTree.NotImplementedTreeImpl(astNode, "METHOD REFERENCE");
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType().toString());
    }

    private ExpressionTree lambdaExpression(AstNode astNode) {
        AstNode body = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.LAMBDA_BODY});
        Object bodyTree = body.hasDirectChildren(new AstNodeType[]{JavaGrammar.BLOCK}) ? this.block(body.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK})) : this.expression(body.getFirstChild());
        ArrayList params = Lists.newArrayList();
        return new LambdaExpressionTreeImpl(astNode, params, (Tree)bodyTree);
    }

    @VisibleForTesting
    ExpressionTree primary(AstNode astNode) {
        AstNode firstChildNode = astNode.getFirstChild();
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION})) {
            return this.expression(firstChildNode);
        }
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS})) {
            if (astNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.THIS})) {
                return new MethodInvocationTreeImpl(astNode, (ExpressionTree)this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaKeyword.THIS})), this.arguments(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
            }
            AstNode explicitGenericInvocationSuffixNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION_SUFFIX});
            if (explicitGenericInvocationSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.SUPER})) {
                return this.applySuperSuffix((ExpressionTree)this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.SUPER})), explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX}));
            }
            return new MethodInvocationTreeImpl(astNode, (ExpressionTree)this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), this.arguments(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
        }
        if (firstChildNode.is(new AstNodeType[]{JavaKeyword.THIS})) {
            IdentifierTree identifier = this.identifier(firstChildNode);
            if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS})) {
                return new MethodInvocationTreeImpl(astNode, (ExpressionTree)identifier, this.arguments(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
            }
            return identifier;
        }
        if (firstChildNode.is(new AstNodeType[]{JavaKeyword.SUPER})) {
            return this.applySuperSuffix((ExpressionTree)this.identifier(firstChildNode), astNode.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX}));
        }
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.LITERAL})) {
            return this.literal(firstChildNode);
        }
        if (firstChildNode.is(new AstNodeType[]{JavaKeyword.NEW})) {
            return this.creator(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CREATOR}));
        }
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER})) {
            ExpressionTree identifier = this.qualifiedIdentifier(firstChildNode);
            AstNode identifierSuffixNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.IDENTIFIER_SUFFIX});
            if (identifierSuffixNode == null) {
                return identifier;
            }
            if (identifierSuffixNode.getFirstChild().is(new AstNodeType[]{JavaPunctuator.LBRK})) {
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.CLASS})) {
                    return new MemberSelectExpressionTreeImpl(astNode, this.applyDim(identifier, identifierSuffixNode.getChildren(new AstNodeType[]{JavaGrammar.DIM}).size() + 1), this.identifier(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.CLASS})));
                }
                return new ArrayAccessExpressionTreeImpl(astNode, identifier, this.expression(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
            }
            if (identifierSuffixNode.getFirstChild().is(new AstNodeType[]{JavaGrammar.ARGUMENTS})) {
                return new MethodInvocationTreeImpl(astNode, identifier, this.arguments(identifierSuffixNode.getFirstChild()));
            }
            if (identifierSuffixNode.getFirstChild().is(new AstNodeType[]{JavaPunctuator.DOT})) {
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.CLASS})) {
                    return new MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.CLASS})));
                }
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION})) {
                    return this.applyExplicitGenericInvocation(identifier, identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION}));
                }
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.THIS})) {
                    return new MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.THIS})));
                }
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.SUPER})) {
                    return new MethodInvocationTreeImpl(astNode, (ExpressionTree)new MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.SUPER}))), this.arguments(identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
                }
                if (identifierSuffixNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.NEW})) {
                    AstNode innerCreatorNode = identifierSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.INNER_CREATOR});
                    return this.applyClassCreatorRest(identifier, (ExpressionTree)this.identifier(innerCreatorNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), innerCreatorNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST}));
                }
                throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getChild(1));
            }
            throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getFirstChild());
        }
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.BASIC_TYPE, JavaKeyword.VOID})) {
            return new MemberSelectExpressionTreeImpl(astNode, this.applyDim((ExpressionTree)this.basicType(firstChildNode), astNode.getChildren(new AstNodeType[]{JavaGrammar.DIM}).size()), this.identifier(astNode.getFirstChild(new AstNodeType[]{JavaKeyword.CLASS})));
        }
        if (firstChildNode.is(new AstNodeType[]{JavaGrammar.LAMBDA_EXPRESSION})) {
            return this.lambdaExpression(firstChildNode);
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + firstChildNode.getType());
    }

    private ExpressionTree creator(AstNode astNode) {
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST})) {
            return this.applyClassCreatorRest(null, this.classType(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CREATED_NAME})), astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST}));
        }
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARRAY_CREATOR_REST})) {
            PrimitiveTypeTree type;
            AstNode arrayCreatorRestNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARRAY_CREATOR_REST});
            AstNode typeNode = arrayCreatorRestNode.getPreviousSibling();
            Object object = type = typeNode.is(new AstNodeType[]{JavaGrammar.BASIC_TYPE}) ? this.basicType(typeNode) : this.classType(typeNode);
            if (arrayCreatorRestNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARRAY_INITIALIZER})) {
                return this.arrayInitializer((Tree)type, arrayCreatorRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARRAY_INITIALIZER}));
            }
            ImmutableList.Builder dimensions = ImmutableList.builder();
            dimensions.add((Object)this.expression(arrayCreatorRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
            for (AstNode dimExpr : arrayCreatorRestNode.getChildren(new AstNodeType[]{JavaGrammar.DIM_EXPR})) {
                dimensions.add((Object)this.expression(dimExpr.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
            }
            return new NewArrayTreeImpl(astNode, (Tree)type, (List<ExpressionTree>)dimensions.build(), (List<ExpressionTree>)ImmutableList.of());
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode);
    }

    private ExpressionTree arrayInitializer(@Nullable Tree t, AstNode astNode) {
        ImmutableList.Builder elems = ImmutableList.builder();
        for (AstNode elem : astNode.getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_INITIALIZER})) {
            elems.add((Object)this.variableInitializer(elem));
        }
        return new NewArrayTreeImpl(astNode, t, (List<ExpressionTree>)ImmutableList.of(), (List<ExpressionTree>)elems.build());
    }

    private ExpressionTree variableInitializer(AstNode astNode) {
        if (astNode.getFirstChild().is(new AstNodeType[]{JavaGrammar.EXPRESSION})) {
            return this.expression(astNode.getFirstChild());
        }
        return this.arrayInitializer(null, astNode.getFirstChild());
    }

    private ExpressionTree unaryExpression(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.CAST_EXPRESSION})) {
            AstNode typeNode = astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getNextSibling();
            Object type = typeNode.is(new AstNodeType[]{JavaGrammar.BASIC_TYPE}) ? this.basicType(typeNode) : this.referenceType(typeNode);
            return new TypeCastExpressionTreeImpl(astNode, (Tree)type, this.expression(astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getNextSibling()));
        }
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.PREFIX_OP, JavaPunctuator.TILDA, JavaPunctuator.BANG})) {
            JavaPunctuator punctuator = astNode.hasDirectChildren(new AstNodeType[]{JavaPunctuator.TILDA, JavaPunctuator.BANG}) ? (JavaPunctuator)astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.TILDA, JavaPunctuator.BANG}).getType() : (JavaPunctuator)astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PREFIX_OP, JavaPunctuator.TILDA, JavaPunctuator.BANG}).getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getPrefixOperator(punctuator);
            return new UnaryExpressionTreeImpl(astNode, kind, this.expression(astNode.getChild(1)));
        }
        Object result = this.expression(astNode.getFirstChild());
        for (AstNode selectorNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.SELECTOR})) {
            result = this.applySelector((ExpressionTree)result, selectorNode);
        }
        for (AstNode postfixOpNode : astNode.getChildren(new AstNodeType[]{JavaGrammar.POST_FIX_OP})) {
            JavaPunctuator punctuator = (JavaPunctuator)postfixOpNode.getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getPostfixOperator(punctuator);
            result = new UnaryExpressionTreeImpl(astNode, kind, (ExpressionTree)result);
        }
        return result;
    }

    private ExpressionTree binaryExpression(AstNode astNode) {
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.INSTANCEOF})) {
            return new InstanceOfTreeImpl(astNode, this.expression(astNode.getFirstChild()), (Tree)this.referenceType(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE})));
        }
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 3; i >= 0; i -= 2) {
            JavaPunctuator punctuator = (JavaPunctuator)astNode.getChild(i + 1).getType();
            Tree.Kind kind = this.kindMaps.getBinaryOperator(punctuator);
            expression = new BinaryExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), kind, (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree conditionalExpression(AstNode astNode) {
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 5; i >= 0; i -= 4) {
            expression = new ConditionalExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), this.expression(astNode.getChild(i + 2)), (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree assignmentExpression(AstNode astNode) {
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 3; i >= 0; i -= 2) {
            JavaPunctuator punctuator = (JavaPunctuator)astNode.getChild(i + 1).getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getAssignmentOperator(punctuator);
            expression = new AssignmentExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), kind, (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree applySelector(ExpressionTree expression, AstNode selectorNode) {
        JavaTreeMaker.checkType(selectorNode, new AstNodeType[]{JavaGrammar.SELECTOR});
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS})) {
            return new MethodInvocationTreeImpl(selectorNode, (ExpressionTree)new MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}))), this.arguments(selectorNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
            return new MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION})) {
            return this.applyExplicitGenericInvocation(expression, selectorNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION}));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.THIS})) {
            return new MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(new AstNodeType[]{JavaKeyword.THIS})));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX})) {
            return this.applySuperSuffix((ExpressionTree)new MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(new AstNodeType[]{JavaKeyword.SUPER}))), selectorNode.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX}));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaKeyword.NEW})) {
            AstNode innerCreatorNode = selectorNode.getFirstChild(new AstNodeType[]{JavaGrammar.INNER_CREATOR});
            return this.applyClassCreatorRest(expression, (ExpressionTree)this.identifier(innerCreatorNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})), innerCreatorNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST}));
        }
        if (selectorNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.DIM_EXPR})) {
            return new ArrayAccessExpressionTreeImpl(selectorNode, expression, this.expression(selectorNode.getFirstChild(new AstNodeType[]{JavaGrammar.DIM_EXPR}).getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})));
        }
        throw new IllegalStateException(AstXmlPrinter.print((AstNode)selectorNode));
    }

    private ExpressionTree applySuperSuffix(ExpressionTree expression, AstNode superSuffixNode) {
        JavaTreeMaker.checkType(superSuffixNode, new AstNodeType[]{JavaGrammar.SUPER_SUFFIX});
        if (superSuffixNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS})) {
            Object methodSelect = expression;
            if (superSuffixNode.hasDirectChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
                methodSelect = new MemberSelectExpressionTreeImpl(superSuffixNode, expression, this.identifier(superSuffixNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})));
            }
            return new MethodInvocationTreeImpl(superSuffixNode, (ExpressionTree)methodSelect, this.arguments(superSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
        }
        return new MemberSelectExpressionTreeImpl(superSuffixNode, expression, this.identifier(superSuffixNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})));
    }

    private ExpressionTree applyClassCreatorRest(ExpressionTree enclosingExpression, ExpressionTree identifier, AstNode classCreatorRestNode) {
        JavaTreeMaker.checkType(classCreatorRestNode, new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST});
        JavaTree.ClassTreeImpl classBody = null;
        if (classCreatorRestNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY})) {
            classBody = new JavaTree.ClassTreeImpl(classCreatorRestNode, Tree.Kind.CLASS, JavaTree.ModifiersTreeImpl.EMPTY, this.classBody(classCreatorRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_BODY})));
        }
        return new NewClassTreeImpl(classCreatorRestNode, enclosingExpression, identifier, this.arguments(classCreatorRestNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})), classBody);
    }

    private ExpressionTree applyExplicitGenericInvocation(ExpressionTree expression, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION});
        AstNode explicitGenericInvocationSuffixNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPLICIT_GENERIC_INVOCATION_SUFFIX});
        if (explicitGenericInvocationSuffixNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX})) {
            expression = new MemberSelectExpressionTreeImpl(astNode, (ExpressionTree)expression, this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaKeyword.SUPER})));
            return this.applySuperSuffix((ExpressionTree)expression, explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX}));
        }
        return new MethodInvocationTreeImpl(astNode, (ExpressionTree)new MemberSelectExpressionTreeImpl(astNode, (ExpressionTree)expression, this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}))), this.arguments(explicitGenericInvocationSuffixNode.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})));
    }

    private List<ExpressionTree> arguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, new AstNodeType[]{JavaGrammar.ARGUMENTS});
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (AstNode argument : astNode.getChildren(new AstNodeType[]{JavaGrammar.EXPRESSION})) {
            arguments.add((Object)this.expression(argument));
        }
        return arguments.build();
    }

    private ExpressionTree applyDim(ExpressionTree expression, int count) {
        Object result = expression;
        for (int i = 0; i < count; ++i) {
            result = new JavaTree.ArrayTypeTreeImpl(null, (Tree)result);
        }
        return result;
    }
}

