/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.parser;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.List;
import org.sonar.javascript.ast.parser.AstNodeReflector;

public class AstNodeSanitizer {
    private int toIndex;

    public void sanitize(AstNode astNode) {
        this.toIndex = 0;
        this.doSanitize(astNode);
    }

    private void doSanitize(AstNode astNode) {
        List<AstNode> children = astNode.getChildren();
        if (!children.isEmpty()) {
            Token token = null;
            int fromIndex = -1;
            for (AstNode child : astNode.getChildren()) {
                this.doSanitize(child);
                if (token == null && child.hasToken()) {
                    token = child.getToken();
                }
                if (fromIndex != -1) continue;
                fromIndex = child.getFromIndex();
            }
            AstNodeReflector.setToken(astNode, token);
            astNode.setFromIndex(fromIndex);
            astNode.setToIndex(this.toIndex);
        } else if (astNode.hasToken()) {
            this.toIndex = astNode.getToIndex();
        } else {
            astNode.setFromIndex(this.toIndex);
            astNode.setToIndex(this.toIndex);
        }
    }
}

