/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.SpecifierListTree;
import org.sonar.javascript.model.interfaces.declaration.SpecifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class SpecifierListTreeImpl
extends JavaScriptTree
implements SpecifierListTree {
    private SyntaxToken openCurlyBraceToken;
    private final SeparatedList<SpecifierTree> specifiers;
    private SyntaxToken closeCurlyBraceToken;
    private final Tree.Kind kind;

    public SpecifierListTreeImpl(Tree.Kind kind, InternalSyntaxToken openCurlyBraceToken, InternalSyntaxToken closeCurlyBraceToken) {
        super(kind);
        this.kind = kind;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.specifiers = null;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
        this.addChildren(openCurlyBraceToken, closeCurlyBraceToken);
    }

    public SpecifierListTreeImpl(Tree.Kind kind, SeparatedList<SpecifierTree> specifiers, List<AstNode> children) {
        super(kind);
        this.kind = kind;
        this.specifiers = specifiers;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public SpecifierListTreeImpl complete(InternalSyntaxToken openCurlyBraceToken, InternalSyntaxToken closeCurlyBraceToken) {
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
        this.prependChildren(openCurlyBraceToken);
        this.addChild(closeCurlyBraceToken);
        return this;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public SeparatedList<SpecifierTree> specifiers() {
        return this.specifiers;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(new Iterator[]{this.specifiers.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSpecifierList(this);
    }
}

