/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class BinaryExpressionTreeImpl
extends JavaScriptTree
implements BinaryExpressionTree {
    private final ExpressionTree leftOperand;
    private final SyntaxToken operand;
    private final ExpressionTree rightOperand;
    private final Tree.Kind kind;

    public BinaryExpressionTreeImpl(Tree.Kind kind, ExpressionTree leftOperand, InternalSyntaxToken operand, ExpressionTree rightOperand) {
        super(kind);
        this.leftOperand = Preconditions.checkNotNull(leftOperand);
        this.operand = operand;
        this.rightOperand = Preconditions.checkNotNull(rightOperand);
        this.kind = Preconditions.checkNotNull(kind);
        this.addChildren((AstNode)((Object)leftOperand), operand, (AstNode)((Object)rightOperand));
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operator() {
        return this.operand;
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.leftOperand, this.rightOperand);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }
}

