/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ComputedPropertyNameTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ComputedPropertyNameTreeImpl
extends JavaScriptTree
implements ComputedPropertyNameTree {
    private final SyntaxToken openBracket;
    private final ExpressionTree expression;
    private final SyntaxToken closeBracket;

    public ComputedPropertyNameTreeImpl(InternalSyntaxToken openBracket, ExpressionTree expression, InternalSyntaxToken closeBracket) {
        super(Tree.Kind.COMPUTED_PROPERTY_NAME);
        this.openBracket = openBracket;
        this.expression = expression;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, (AstNode)((Object)expression), closeBracket);
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openBracket;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.COMPUTED_PROPERTY_NAME;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator(this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitComputedPropertyName(this);
    }
}

