/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.ForOfStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class ForOfStatementTreeImpl
extends JavaScriptTree
implements ForOfStatementTree {
    private final SyntaxToken forKeyword;
    private final SyntaxToken openParenthesis;
    private final Tree variableOrExpression;
    private final SyntaxToken ofKeyword;
    private final ExpressionTree expression;
    private final SyntaxToken closeParenthesis;
    private final StatementTree statement;

    public ForOfStatementTreeImpl(InternalSyntaxToken forKeyword, InternalSyntaxToken openParenthesis, Tree variableOrExpression, InternalSyntaxToken ofKeyword, ExpressionTree expression, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        super(Tree.Kind.FOR_OF_STATEMENT);
        this.forKeyword = forKeyword;
        this.openParenthesis = openParenthesis;
        this.variableOrExpression = variableOrExpression;
        this.ofKeyword = ofKeyword;
        this.expression = expression;
        this.closeParenthesis = closeParenthesis;
        this.statement = statement;
        this.addChildren(forKeyword, openParenthesis, (AstNode)((Object)variableOrExpression), ofKeyword, (AstNode)((Object)expression), closeParenthesis, (AstNode)((Object)statement));
    }

    @Override
    public SyntaxToken forKeyword() {
        return this.forKeyword;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public Tree variableOrExpression() {
        return this.variableOrExpression;
    }

    @Override
    public SyntaxToken ofKeyword() {
        return this.ofKeyword;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_OF_STATEMENT;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.variableOrExpression, this.expression, this.statement);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForOfStatement(this);
    }
}

