/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class LabelledStatementTreeImpl
extends JavaScriptTree
implements LabelledStatementTree {
    private final IdentifierTree label;
    private final SyntaxToken colon;
    private final StatementTree statement;

    public LabelledStatementTreeImpl(IdentifierTree label, InternalSyntaxToken colon, StatementTree statement) {
        super(Tree.Kind.LABELLED_STATEMENT);
        this.label = label;
        this.colon = colon;
        this.statement = statement;
        this.addChild((AstNode)((Object)label));
        this.addChild(colon);
        this.addChild((AstNode)((Object)statement));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LABELLED_STATEMENT;
    }

    @Override
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public SyntaxToken colon() {
        return this.colon;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.label, this.statement);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLabelledStatement(this);
    }
}

