/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.implementations.statement.BlockTreeImpl;
import org.sonar.javascript.model.implementations.statement.CatchBlockTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.CatchBlockTree;
import org.sonar.javascript.model.interfaces.statement.TryStatementTree;

public class TryStatementTreeImpl
extends JavaScriptTree
implements TryStatementTree {
    private SyntaxToken tryKeyword;
    private BlockTree block;
    @Nullable
    private CatchBlockTree catchBlock;
    @Nullable
    private SyntaxToken finallyKeyword;
    @Nullable
    private BlockTree finallyBlock;

    public TryStatementTreeImpl(CatchBlockTreeImpl catchBlock) {
        super(Tree.Kind.TRY_STATEMENT);
        this.catchBlock = catchBlock;
        this.addChildren(catchBlock);
    }

    public TryStatementTreeImpl(InternalSyntaxToken finallyKeyword, BlockTreeImpl finallyBlock) {
        super(Tree.Kind.TRY_STATEMENT);
        this.finallyKeyword = finallyKeyword;
        this.finallyBlock = finallyBlock;
        this.addChildren(finallyKeyword, finallyBlock);
    }

    public TryStatementTreeImpl complete(CatchBlockTreeImpl catchBlock) {
        Preconditions.checkState(this.catchBlock == null, "Catch block already completed");
        this.catchBlock = catchBlock;
        this.prependChildren(catchBlock);
        return this;
    }

    public TryStatementTreeImpl complete(InternalSyntaxToken tryKeyword, BlockTreeImpl block) {
        Preconditions.checkState(this.tryKeyword == null, "Already completed");
        this.tryKeyword = tryKeyword;
        this.block = block;
        this.prependChildren(tryKeyword, block);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STATEMENT;
    }

    @Override
    public SyntaxToken tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public CatchBlockTree catchBlock() {
        return this.catchBlock;
    }

    @Override
    @Nullable
    public SyntaxToken finallyKeyword() {
        return this.finallyKeyword;
    }

    @Override
    @Nullable
    public BlockTree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.block, this.catchBlock, this.finallyBlock);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }
}

