/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1717", priority=Priority.MAJOR, name="\"\\\" should only be used as an escape character outside of raw strings")
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class BackslashInStringCheck
extends SquidCheck<Grammar> {
    private static final String MESSAGE = "Remove this \"\\\", add another \"\\\" to escape it, or make this a raw string.";
    private static final String VALID_ESCAPED_CHARACTERS = "abfnrtvxnNrtuU\\'\"0123456789\n\r";
    public static final String CHECK_KEY = "S1717";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.STRING});
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        int length = string.length();
        boolean isEscaped = false;
        boolean inPrefix = true;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if ((inPrefix = this.isInPrefix(inPrefix, c)) && (c == 'r' || c == 'R')) {
                return;
            }
            if (inPrefix) continue;
            if (isEscaped && VALID_ESCAPED_CHARACTERS.indexOf(c) == -1) {
                this.getContext().createLineViolation((CodeCheck)this, MESSAGE, node, new Object[0]);
            }
            isEscaped = c == '\\' && !isEscaped;
        }
    }

    private boolean isInPrefix(boolean wasInPrefix, char currentChar) {
        return wasInPrefix && currentChar != '\"' && currentChar != '\'';
    }
}

