/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1722", priority=Priority.MAJOR, name="New-style classes should be used")
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class NewStyleClassCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1722";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode node) {
        AstNode argListNode = node.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (argListNode == null || !argListNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ARGUMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Add inheritance from \"object\" or some other new-style class.", node.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}), new Object[0]);
        }
    }
}

