/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="ExecStatementUsage", priority=Priority.MAJOR, name="The \"exec\" statement should not be used", tags={"obsolete"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class ExecStatementUsageCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "ExecStatementUsage";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.EXEC_STMT});
    }

    public void visitNode(AstNode astNode) {
        this.getContext().createLineViolation((CodeCheck)this, "Do not use exec statement.", astNode, new Object[0]);
    }
}

