/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S2325", priority=Priority.MAJOR, name="Methods that don't access instance data should be \"static\"", tags={"performance"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class MethodShouldBeStaticCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S2325";
    private static final String MESSAGE = "Make this method static.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        String self;
        if (CheckUtils.isMethodDefinition(node) && !this.alreadyStaticMethod(node) && this.hasValuableCode(node) && (self = this.getFirstArgument(node)) != null && !this.isUsed(node, self)) {
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), new Object[0]);
        }
    }

    private boolean hasValuableCode(AstNode funcDef) {
        AstNode statementList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (statementList != null && statementList.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).size() == 1) {
            return !statementList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).getFirstChild().is(new AstNodeType[]{PythonGrammar.PASS_STMT});
        }
        List statements = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1) {
            return !this.isDocstringOrPass((AstNode)statements.get(0));
        }
        return statements.size() != 2 || !this.isDocstringAndPass((AstNode)statements.get(0), (AstNode)statements.get(1));
    }

    private boolean isDocstringOrPass(AstNode statement) {
        return statement.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null || statement.getToken().getType().equals(PythonTokenType.STRING);
    }

    private boolean isDocstringAndPass(AstNode statement1, AstNode statement2) {
        return statement1.getToken().getType().equals(PythonTokenType.STRING) && statement2.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null;
    }

    private boolean isUsed(AstNode funcDef, String self) {
        List names = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getDescendants(new AstNodeType[]{PythonGrammar.NAME});
        for (AstNode name : names) {
            if (!name.getTokenValue().equals(self)) continue;
            return true;
        }
        return false;
    }

    private String getFirstArgument(AstNode funcDef) {
        AstNode argList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (argList != null) {
            return argList.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue();
        }
        return null;
    }

    private boolean alreadyStaticMethod(AstNode funcDef) {
        AstNode decorators = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        if (decorators != null) {
            List decoratorList = decorators.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR});
            for (AstNode decorator : decoratorList) {
                AstNode name = decorator.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME});
                if (name == null || !"staticmethod".equals(name.getTokenValue()) && !"classmethod".equals(name.getTokenValue())) continue;
                return true;
            }
        }
        return false;
    }
}

