/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S2772", priority=Priority.MAJOR, name="\"pass\" should not be used needlessly", tags={"unused"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class NeedlessPassCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S2772";
    private static final String MESSAGE = "Remove this unneeded \"pass\".";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.PASS_STMT});
    }

    public void visitNode(AstNode node) {
        AstNode suite = node.getFirstAncestor((AstNodeType)PythonGrammar.SUITE);
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() > 1) {
            if (!this.docstringException(statements)) {
                this.raiseIssue(node);
            }
        } else {
            this.visitOneOrZeroStatement(node, suite, statements.size());
        }
    }

    private boolean docstringException(List<AstNode> statements) {
        return statements.size() == 2 && statements.get(0).getToken().getType().equals(PythonTokenType.STRING);
    }

    private void visitOneOrZeroStatement(AstNode node, AstNode suite, int statementNumber) {
        AstSelect simpleStatements = statementNumber == 1 ? suite.select().children((AstNodeType)PythonGrammar.STATEMENT).children((AstNodeType)PythonGrammar.STMT_LIST).children((AstNodeType)PythonGrammar.SIMPLE_STMT) : suite.select().children((AstNodeType)PythonGrammar.STMT_LIST).children((AstNodeType)PythonGrammar.SIMPLE_STMT);
        if (simpleStatements.size() > 1) {
            this.raiseIssue(node);
        }
    }

    private void raiseIssue(AstNode node) {
        this.getContext().createLineViolation((CodeCheck)this, MESSAGE, node, new Object[0]);
    }
}

