/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ExtendedStackTraceStream;
import com.sonar.sslr.impl.events.FastStackMatcherAndPosition;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Stack;

public final class ExtendedStackTrace
extends ParsingEventListener {
    public final FastStackMatcherAndPosition currentStack = new FastStackMatcherAndPosition();
    public final FastStackMatcherAndPosition longestStack = new FastStackMatcherAndPosition();
    private final Stack<Integer> currentStackRules = new Stack();
    public Matcher longestOutertMatcher;
    public Matcher longestMatcher;
    public int longestIndex;
    public ParsingState longestParsingState;

    public void beginParse() {
        this.currentStack.clear();
        this.longestStack.clear();
        this.currentStackRules.clear();
        this.longestIndex = -1;
    }

    public void enterRule(RuleMatcher rule, ParsingState parsingState) {
        int lastRuleWithPosition = ExtendedStackTrace.getLastRuleWithPosition(this.currentStack);
        if (lastRuleWithPosition != -1) {
            this.currentStack.setToIndex(lastRuleWithPosition, parsingState.lexerIndex);
        }
        this.currentStackRules.push(this.currentStack.size());
        this.currentStack.push(rule, parsingState.lexerIndex);
    }

    public void exitWithMatchRule(RuleMatcher rule, ParsingState parsingState, AstNode astNode) {
        this.currentStackRules.pop();
        this.currentStack.pop();
    }

    public void exitWithoutMatchRule(RuleMatcher rule, ParsingState parsingState) {
        this.currentStackRules.pop();
        this.currentStack.pop();
    }

    public void enterMatcher(Matcher matcher, ParsingState parsingState) {
        this.currentStack.push(matcher, parsingState.lexerIndex);
    }

    public void exitWithMatchMatcher(Matcher matcher, ParsingState parsingState, AstNode astNode) {
        this.currentStack.pop();
    }

    public void exitWithoutMatchMatcher(Matcher matcher, ParsingState parsingState) {
        if (ExtendedStackTrace.enforceLexerIndexUpperBound(parsingState.lexerIndex, parsingState.lexerSize) > this.longestIndex) {
            this.longestIndex = ExtendedStackTrace.enforceLexerIndexUpperBound(parsingState.lexerIndex, parsingState.lexerSize);
            this.longestMatcher = this.currentStack.peekMatcher();
            this.longestOutertMatcher = ExtendedStackTrace.getOuterMatcher(this.currentStack, this.currentStack.peekFromIndex());
            int lastRuleWithPosition = ExtendedStackTrace.getLastRuleWithPosition(this.currentStack);
            if (lastRuleWithPosition != -1) {
                this.currentStack.setToIndex(lastRuleWithPosition, parsingState.lexerIndex);
            }
            FastStackMatcherAndPosition.copyOnlyRuleMatchers(this.longestStack, this.currentStack, this.currentStackRules);
            this.longestParsingState = parsingState;
        }
        this.currentStack.pop();
    }

    private static int enforceLexerIndexUpperBound(int index, int lexerSize) {
        return index < lexerSize ? index : lexerSize - 1;
    }

    private static int getLastRuleWithPosition(FastStackMatcherAndPosition stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (!(stack.getMatcher(i) instanceof RuleMatcher)) continue;
            return i;
        }
        return -1;
    }

    private static Matcher getOuterMatcher(FastStackMatcherAndPosition stack, int lexerIndex) {
        for (int i = 0; i < stack.size(); ++i) {
            if (stack.getFromIndex(i) != lexerIndex) continue;
            return stack.getMatcher(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PrintStream stream = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            stream = new PrintStream(baos);
            ExtendedStackTraceStream.print(this, stream);
            String string = baos.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

