/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import sharpen.core.Configuration;

public class DefaultConfiguration
extends Configuration {
    DefaultConfiguration(String runtimeTypeName) {
        super(runtimeTypeName);
        this.setUpPrimitiveMappings();
        this.setUpAnnotationMappings();
        this.mapType("java.lang.System", runtimeTypeName);
        this.mapType("java.lang.Math", "System.Math");
        this.mapMethod("java.lang.System.exit", "System.Environment.Exit");
        this.setUpIoMappings();
        this.setUpExceptionMappings();
        this.setUpCollectionMappings();
        this.mapType("java.lang.Cloneable", "System.ICloneable");
        this.mapType("java.util.Date", "System.DateTime");
        this.mapMethod("java.lang.Object.toString", "ToString");
        this.mapMethod("java.lang.Object.hashCode", "GetHashCode");
        this.mapMethod("java.lang.Object.equals", "Equals");
        this.mapMethod("java.lang.Float.isNaN", "float.IsNaN");
        this.mapMethod("java.lang.Double.isNaN", "double.IsNaN");
        this.setUpStringMappings();
        this.mapMethod("java.lang.Throwable.printStackTrace", this.runtimeMethod("printStackTrace"));
        this.mapMethod("java.lang.System.arraycopy", "System.Array.Copy");
        this.mapMethod("java.lang.Object.wait", this.runtimeMethod("wait"));
        this.mapMethod("java.lang.Object.notify", this.runtimeMethod("notify"));
        this.mapMethod("java.lang.Object.notifyAll", this.runtimeMethod("notifyAll"));
        this.mapMethod("java.lang.Object.getClass", this.runtimeMethod("getClassForObject"));
        this.mapMethod("length", "Length");
        this.setUpPrimitiveWrappers();
    }

    private void setUpPrimitiveMappings() {
        this.mapType("boolean", "bool");
        this.mapPrimitive("void");
        this.mapPrimitive("char");
        this.mapType("byte", "sbyte");
        this.mapPrimitive("short");
        this.mapPrimitive("int");
        this.mapPrimitive("long");
        this.mapPrimitive("float");
        this.mapPrimitive("double");
        this.mapType("ubyte", "byte");
        this.mapType("java.lang.Object", "object");
        this.mapType("java.lang.String", "string");
        this.mapType("java.lang.Character", "char");
        this.mapType("java.lang.Byte", "sbyte");
        this.mapType("java.lang.Boolean", "bool");
        this.mapType("java.lang.Short", "short");
        this.mapType("java.lang.Integer", "int");
        this.mapType("java.lang.Long", "long");
        this.mapType("java.lang.Float", "float");
        this.mapType("java.lang.Double", "double");
    }

    private void setUpCollectionMappings() {
        this.mapType("java.util.Collection", "System.Collections.ICollection");
        this.mapType("java.util.Collection<>", "System.Collections.Generic.ICollection");
        this.mapType("java.util.Set<>", "System.Collections.Generic.ICollection");
        if (this.mapIteratorToEnumerator()) {
            this.mapType("java.util.Iterator", "System.Collections.IEnumerator");
            this.mapType("java.util.Iterator<>", "System.Collections.Generic.IEnumerator");
            this.mapType("java.lang.Iterable", "System.Collections.IEnumerable");
            this.mapType("java.lang.Iterable<>", "System.Collections.Generic.IEnumerable");
        }
        this.mapType("java.util.Map", "System.Collections.IDictionary");
        this.mapType("java.util.Map<,>", "System.Collections.Generic.IDictionary");
        this.mapType("java.util.Map.Entry", "System.Collections.DictionaryEntry");
        this.mapType("java.util.Map.Entry<,>", "System.Collections.Generic.KeyValuePair");
        this.mapType("java.util.HashMap", "System.Collections.Hashtable");
        this.mapType("java.util.HashMap<,>", "System.Collections.Generic.Dictionary");
        this.mapType("java.util.TreeMap", "System.Collections.SortedList");
        this.mapType("java.util.TreeMap<,>", "System.Collections.Generic.SortedDictionary");
        this.mapType("java.util.SortedMap<,>", "System.Collections.Generic.SortedDictionary");
        this.mapType("java.util.List", "System.Collections.IList");
        this.mapType("java.util.List<>", "System.Collections.Generic.IList");
        this.mapType("java.util.ArrayList", "System.Collections.ArrayList");
        this.mapType("java.util.ArrayList<>", "System.Collections.Generic.List");
        this.mapType("java.util.LinkedList", "System.Collections.ArrayList");
        this.mapType("java.util.LinkedList<>", "System.Collections.Generic.LinkedList");
        this.mapType("java.util.Stack", "System.Collections.Stack");
        this.mapProperty("java.util.LinkedList<>.getFirst", "First");
        this.mapType("java.util.Comparator", "System.Collections.IComparer");
        this.mapMethod("java.util.Collections.sort", "Sort");
        this.mapProperty("java.util.Collection.size", "Count");
        this.mapProperty("java.util.Map.size", "Count");
        this.mapProperty("java.util.List.size", "Count");
        this.mapIndexer("java.util.List.get");
        this.mapMethod("java.util.Collection.addAll", this.collectionRuntimeMethod("AddAll"));
        this.mapMethod("java.util.Collection.toArray", this.collectionRuntimeMethod("ToArray"));
        if (this.mapIteratorToEnumerator()) {
            this.mapMethod("java.lang.Iterable.iterator", "GetEnumerator");
            this.mapMethod("java.util.Collection.iterator", "GetEnumerator");
            this.mapMethod("java.util.List.iterator", "GetEnumerator");
            this.mapMethod("java.util.Set.iterator", "GetEnumerator");
            this.mapMethod("java.util.Iterator.hasNext", "MoveNext");
            this.mapProperty("java.util.Iterator.next", "Current");
        }
        this.mapMethod("java.util.Map.remove", this.collectionRuntimeMethod("Remove"));
        this.mapProperty("java.util.Map.Entry.getKey", "Key");
        this.mapProperty("java.util.Map.Entry.getValue", "Value");
        this.mapProperty("java.util.Map.values", "Values");
        this.mapProperty("java.util.Map.keySet", "Keys");
        this.mapIndexer("java.util.Dictionary.get");
        this.mapType("java.util.Vector", "System.Collections.ArrayList");
        this.mapType("java.util.Enumeration", "System.Collections.IEnumerator");
        this.mapProperty("java.util.Vector.size", "Count");
        this.mapProperty("java.util.AbstractCollection.size", "Count");
        this.mapMethod("java.util.Vector.addElement", "Add");
        this.mapIndexer("java.util.Vector.elementAt");
        this.mapMethod("java.util.Vector.elements", "GetEnumerator");
        this.mapMethod("java.util.Vector.copyInto", "CopyTo");
        this.mapMethod("java.util.Vector.removeAllElements", "Clear");
        this.mapMethod("java.util.Enumeration.hasMoreElements", "MoveNext");
        this.mapProperty("java.util.Enumeration.nextElement", "Current");
        this.mapType("java.util.Hashtable", "System.Collections.Hashtable");
        this.mapProperty("java.util.Dictionary.keys", "Keys");
        this.mapProperty("java.util.Dictionary.size", "Count");
        this.mapNamespace("junit.framework", "NUnit.Framework");
        this.mapMethod("junit.framework.Assert.assertEquals", "NUnit.Framework.Assert.AreEqual");
        this.mapMethod("junit.framework.Assert.assertTrue", "NUnit.Framework.Assert.IsTrue");
        this.mapMethod("junit.framework.Assert.assertFalse", "NUnit.Framework.Assert.IsFalse");
        this.mapMethod("junit.framework.Assert.assertNotNull", "NUnit.Framework.Assert.IsNotNull");
        this.mapMethod("junit.framework.Assert.assertNull", "NUnit.Framework.Assert.IsNull");
        this.mapMethod("junit.framework.Assert.assertSame", "NUnit.Framework.Assert.AreSame");
        this.mapMethod("junit.framework.Assert.assertNotSame", "NUnit.Framework.Assert.AreNotSame");
        this.mapNamespace("org.junit", "NUnit.Framework");
        this.mapMethod("org.junit.Assert.assertEquals", "NUnit.Framework.Assert.AreEqual");
        this.mapMethod("org.junit.Assert.assertTrue", "NUnit.Framework.Assert.IsTrue");
        this.mapMethod("org.junit.Assert.assertFalse", "NUnit.Framework.Assert.IsFalse");
        this.mapMethod("org.junit.Assert.assertNotNull", "NUnit.Framework.Assert.IsNotNull");
        this.mapMethod("org.junit.Assert.assertNull", "NUnit.Framework.Assert.IsNull");
        this.mapMethod("org.junit.Assert.assertSame", "NUnit.Framework.Assert.AreSame");
        this.mapMethod("org.junit.Assert.assertNotSame", "NUnit.Framework.Assert.AreNotSame");
        this.mapMethod("org.junit.Assert.fail", "NUnit.Framework.Assert.Fail");
        this.mapType("org.junit.Assert", "NUnit.Framework.Assert");
        this.mapType("org.junit.Before", "NUnit.Framework.SetUp");
        this.mapType("org.junit.After", "NUnit.Framework.TearDown");
    }

    private void setUpExceptionMappings() {
        this.mapType("java.lang.Throwable", "System.Exception");
        this.mapProperty("java.lang.Throwable.getMessage", "Message");
        this.mapProperty("java.lang.Throwable.getCause", "InnerException");
        this.mapType("java.lang.Error", "System.Exception");
        this.mapType("java.lang.OutOfMemoryError", "System.OutOfMemoryException");
        this.mapType("java.lang.Exception", "System.Exception");
        this.mapType("java.lang.RuntimeException", "System.Exception");
        this.mapType("java.lang.ClassCastException", "System.InvalidCastException");
        this.mapType("java.lang.NullPointerException", "System.ArgumentNullException");
        this.mapType("java.lang.IllegalArgumentException", "System.ArgumentException");
        this.mapType("java.lang.IllegalStateException", "System.InvalidOperationException");
        this.mapType("java.lang.InterruptedException", "System.Exception");
        this.mapType("java.lang.IndexOutOfBoundsException", "System.IndexOutOfRangeException");
        this.mapType("java.lang.UnsupportedOperationException", "System.NotSupportedException");
        this.mapType("java.lang.ArrayIndexOutOfBoundsException", "System.IndexOutOfRangeException");
        this.mapType("java.lang.NoSuchMethodError", "System.MissingMethodException");
        this.mapType("java.io.IOException", "System.IO.IOException");
        this.mapType("java.net.SocketException", "System.Net.Sockets.SocketException");
        this.mapType("java.lang.SecurityException", "System.Security.SecurityException");
    }

    private void setUpPrimitiveWrappers() {
        this.mapField("java.lang.Short.MAX_VALUE", "short.MaxValue");
        this.mapField("java.lang.Short.MIN_VALUE", "short.MinValue");
        this.mapField("java.lang.Integer.MAX_VALUE", "int.MaxValue");
        this.mapField("java.lang.Integer.MIN_VALUE", "int.MinValue");
        this.mapField("java.lang.Long.MAX_VALUE", "long.MaxValue");
        this.mapField("java.lang.Long.MIN_VALUE", "long.MinValue");
        this.mapField("java.lang.Float.MAX_VALUE", "float.MaxValue");
        this.mapField("java.lang.Float.MIN_VALUE", "float.MinValue");
        this.mapField("java.lang.Float.POSITIVE_INFINITY", "float.PositiveInfinity");
        this.mapField("java.lang.Float.NEGATIVE_INFINITY", "float.NegativeInfinity");
        this.mapField("java.lang.Double.MAX_VALUE", "double.MaxValue");
        this.mapField("java.lang.Double.MIN_VALUE", "double.MinValue");
        this.mapField("java.lang.Double.NEGATIVE_INFINITY", "double.NegativeInfinity");
        this.mapField("java.lang.Double.POSITIVE_INFINITY", "double.PositiveInfinity");
        this.mapField("java.lang.Boolean.TRUE", "true");
        this.mapField("java.lang.Boolean.FALSE", "false");
        this.mapField("java.lang.Byte.MAX_VALUE", "sbyte.MaxValue");
        this.mapField("java.lang.Byte.MIN_VALUE", "sbyte.MinValue");
        this.mapField("java.lang.Character.MAX_VALUE", "char.MaxValue");
        this.mapField("java.lang.Character.MIN_VALUE", "char.MinValue");
        this.mapMethod("java.lang.Character.isWhitespace", "char.IsWhiteSpace");
        this.mapWrapperConstructor("java.lang.Boolean.Boolean", "System.Convert.ToBoolean", "boolean");
        this.mapWrapperConstructor("java.lang.Byte.Byte", "System.Convert.ToSByte", "sbyte");
        this.mapWrapperConstructor("java.lang.Character.Character", "System.Convert.ToChar", "char");
        this.mapWrapperConstructor("java.lang.Short.Short", "System.Convert.ToInt16", "short");
        this.mapWrapperConstructor("java.lang.Integer.Integer", "System.Convert.ToInt32", "int");
        this.mapWrapperConstructor("java.lang.Long.Long", "System.Convert.ToInt64", "long");
        this.mapWrapperConstructor("java.lang.Float.Float", "System.Convert.ToSingle", "float");
        this.mapWrapperConstructor("java.lang.Double.Double", "System.Convert.ToDouble", "double");
        this.mapMethod("java.lang.Long.toString", "System.Convert.ToString");
        this.mapMethod("java.lang.Long.parseLong", "long.Parse");
        this.mapMethod("java.lang.Integer.valueOf", "int.Parse");
        this.mapMethod("java.lang.Integer.parseInt", "System.Convert.ToInt32");
        this.mapMethod("java.lang.Number.shortValue", "");
        this.mapMethod("java.lang.Number.intValue", "");
        this.mapMethod("java.lang.Number.longValue", "");
        this.mapMethod("java.lang.Number.byteValue", "");
        this.mapMethod("java.lang.Number.floatValue", "");
        this.mapMethod("java.lang.Number.doubleValue", "");
        this.mapMethod("java.lang.Character.charValue", "");
        this.mapMethod("java.lang.Boolean.booleanValue", "");
        this.mapMethod("java.lang.Float.floatToIntBits", this.runtimeMethod("floatToIntBits"));
        this.mapMethod("java.lang.Float.intBitsToFloat", this.runtimeMethod("intBitsToFloat"));
    }

    @Override
    public boolean isIgnoredExceptionType(String exceptionType) {
        return exceptionType.equals("java.lang.CloneNotSupportedException");
    }

    @Override
    public boolean mapByteToSbyte() {
        return false;
    }
}

