/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import sharpen.core.Mappings;
import sharpen.core.NameScope;
import sharpen.core.SharpenAnnotations;
import sharpen.core.framework.Environments;

public class NameScopeImpl
implements NameScope {
    private Stack<AbstractTypeDeclaration> _currentType = new Stack();
    private List<String> _mappedMethodDeclarations = new ArrayList<String>();

    @Override
    public boolean contains(String name) {
        return this._mappedMethodDeclarations.contains(name);
    }

    @Override
    public void enterTypeDeclaration(AbstractTypeDeclaration node) {
        this._currentType.push(node);
        this._mappedMethodDeclarations.clear();
        for (MethodDeclaration meth : NameScopeImpl.getMethods(node)) {
            if (SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)meth)) continue;
            this._mappedMethodDeclarations.add(Environments.my(Mappings.class).mappedMethodName(meth.resolveBinding()));
        }
    }

    @Override
    public void leaveTypeDeclaration(AbstractTypeDeclaration node) {
        this._currentType.pop();
    }

    @Override
    public AbstractTypeDeclaration currentType() {
        return this._currentType.peek();
    }

    private static MethodDeclaration[] getMethods(AbstractTypeDeclaration node) {
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).getMethods();
        }
        if (node instanceof EnumDeclaration) {
            ArrayList<MethodDeclaration> methodsList = new ArrayList<MethodDeclaration>();
            for (Object declaration : node.bodyDeclarations()) {
                if (!(declaration instanceof MethodDeclaration)) continue;
                methodsList.add((MethodDeclaration)declaration);
            }
            return methodsList.toArray(new MethodDeclaration[methodsList.size()]);
        }
        throw new UnsupportedOperationException("not implemented");
    }
}

