/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.internal.SutController;
import org.evomaster.clientJava.controllerApi.dto.ControllerInfoDto;
import org.evomaster.clientJava.controllerApi.dto.ExtraHeuristicDto;
import org.evomaster.clientJava.controllerApi.dto.SutInfoDto;
import org.evomaster.clientJava.controllerApi.dto.SutRunDto;
import org.evomaster.clientJava.controllerApi.dto.TargetInfoDto;
import org.evomaster.clientJava.controllerApi.dto.TargetsResponseDto;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import shaded.javax.ws.rs.Consumes;
import shaded.javax.ws.rs.DELETE;
import shaded.javax.ws.rs.DefaultValue;
import shaded.javax.ws.rs.FormParam;
import shaded.javax.ws.rs.GET;
import shaded.javax.ws.rs.POST;
import shaded.javax.ws.rs.PUT;
import shaded.javax.ws.rs.Path;
import shaded.javax.ws.rs.Produces;
import shaded.javax.ws.rs.QueryParam;
import shaded.javax.ws.rs.WebApplicationException;

@Path(value="")
public class EMController {
    private final SutController sutController;
    private String baseUrlOfSUT;

    public EMController(SutController sutController) {
        this.sutController = Objects.requireNonNull(sutController);
    }

    @Path(value="/infoSUT")
    @GET
    @Produces(value={"application/json;charset=utf8;version=1"})
    public SutInfoDto getSutInfo() {
        SutInfoDto dto = new SutInfoDto();
        dto.swaggerJsonUrl = this.sutController.getUrlOfSwaggerJSON();
        dto.endpointsToSkip = this.sutController.getEndpointsToSkip();
        dto.isSutRunning = this.sutController.isSutRunning();
        dto.baseUrlOfSUT = this.baseUrlOfSUT;
        dto.infoForAuthentication = this.sutController.getInfoForAuthentication();
        return dto;
    }

    @Path(value="/controllerInfo")
    @GET
    @Produces(value={"application/json;charset=utf8;version=1"})
    public ControllerInfoDto getControllerInfoDto() {
        ControllerInfoDto dto = new ControllerInfoDto();
        dto.fullName = this.sutController.getClass().getName();
        dto.isInstrumentationOn = this.sutController.isInstrumentationActivated();
        return dto;
    }

    @Path(value="/newSearch")
    @POST
    public void newSearch() {
        this.sutController.newSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/runSUT")
    @PUT
    @Consumes(value={"application/json;charset=utf8;version=1"})
    public void runSut(SutRunDto dto) {
        try {
            if (dto.run == null) {
                throw new WebApplicationException("Invalid JSON: 'run' field is required", 400);
            }
            boolean newlyStarted = false;
            EMController eMController = this;
            synchronized (eMController) {
                if (dto.run.booleanValue()) {
                    if (!this.sutController.isSutRunning()) {
                        this.baseUrlOfSUT = this.sutController.startSut();
                        if (this.baseUrlOfSUT == null) {
                            throw new WebApplicationException("Internal failure: cannot start SUT based on given configuration", 500);
                        }
                        this.sutController.initSqlHandler();
                        this.sutController.newTest();
                        newlyStarted = true;
                    }
                } else if (this.sutController.isSutRunning()) {
                    this.sutController.stopSut();
                    this.baseUrlOfSUT = null;
                }
                if (dto.resetState != null && dto.resetState.booleanValue()) {
                    if (!dto.run.booleanValue()) {
                        throw new WebApplicationException("Invalid JSON: cannot reset state and stop service at same time", 400);
                    }
                    if (!newlyStarted) {
                        this.sutController.resetStateOfSUT();
                        this.sutController.newTest();
                    }
                }
            }
        }
        catch (RuntimeException e) {
            SimpleLogger.error("ERROR -> " + e.getMessage());
            throw e;
        }
    }

    @Path(value="/targets")
    @GET
    @Produces(value={"application/json;charset=utf8;version=1"})
    public TargetsResponseDto getTargets(@QueryParam(value="ids") @DefaultValue(value="") String idList) {
        Set<Integer> ids;
        TargetsResponseDto dto = new TargetsResponseDto();
        try {
            ids = Arrays.asList(idList.split(",")).stream().filter(s -> !s.trim().isEmpty()).map(Integer::parseInt).collect(Collectors.toSet());
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException("Invalid parameter 'ids': " + e.getMessage(), e);
        }
        List<TargetInfo> list = this.sutController.getTargetInfos(ids);
        if (list == null) {
            String msg = "Failed to collect target information for " + ids.size() + " ids";
            SimpleLogger.error(msg);
            throw new WebApplicationException(msg, 500);
        }
        list.stream().forEach(t -> {
            TargetInfoDto info = new TargetInfoDto();
            info.id = t.mappedId;
            info.value = t.value;
            info.descriptiveId = t.descriptiveId;
            info.actionIndex = t.actionIndex;
            targetsResponseDto.targets.add(info);
        });
        return dto;
    }

    @Path(value="/extraHeuristics")
    @GET
    @Produces(value={"application/json;charset=utf8;version=1"})
    public ExtraHeuristicDto getExtra() {
        ExtraHeuristicDto dto = this.sutController.getExtraHeuristics();
        return dto;
    }

    @Path(value="/extraHeuristics")
    @DELETE
    public void deleteExtra() {
        this.sutController.resetExtraHeuristics();
    }

    @Path(value="/newAction")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @PUT
    public void newAction(@FormParam(value="index") int index) {
        this.sutController.newAction(index);
    }
}

