/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.db.DataRow;
import org.evomaster.clientJava.instrumentation.testability.StringTransformer;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.expression.NullValue;
import shaded.net.sf.jsqlparser.expression.Parenthesis;
import shaded.net.sf.jsqlparser.expression.SignedExpression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.InExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import shaded.net.sf.jsqlparser.schema.Column;

public class HeuristicsCalculator {
    private final Map<String, String> tableAliases;

    public HeuristicsCalculator(Map<String, String> aliases) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (aliases != null) {
            map.putAll(aliases);
        }
        this.tableAliases = Collections.unmodifiableMap(map);
    }

    public double computeExpression(Expression exp, DataRow data) {
        if (exp instanceof ComparisonOperator) {
            return this.computeComparisonOperator((ComparisonOperator)exp, data);
        }
        if (exp instanceof AndExpression) {
            return this.computeAnd((AndExpression)exp, data);
        }
        if (exp instanceof OrExpression) {
            return this.computeOr((OrExpression)exp, data);
        }
        if (exp instanceof IsNullExpression) {
            return this.computeIsNull((IsNullExpression)exp, data);
        }
        if (exp instanceof InExpression) {
            return this.computeInExpression((InExpression)exp, data);
        }
        if (exp instanceof Parenthesis) {
            return this.computeExpression(((Parenthesis)exp).getExpression(), data);
        }
        return this.cannotHandle(exp);
    }

    private double computeInExpression(InExpression exp, DataRow data) {
        ItemsList itemsList = exp.getRightItemsList();
        if (itemsList instanceof ExpressionList) {
            ExpressionList list = (ExpressionList)itemsList;
            if (exp.isNot()) {
                double max = 0.0;
                for (Expression element : list.getExpressions()) {
                    NotEqualsTo op = new NotEqualsTo();
                    op.setLeftExpression(exp.getLeftExpression());
                    op.setRightExpression(element);
                    double dist = this.computeComparisonOperator(op, data);
                    if (!(dist > max)) continue;
                    max = dist;
                    break;
                }
                return max;
            }
            double min = Double.MAX_VALUE;
            for (Expression element : list.getExpressions()) {
                EqualsTo op = new EqualsTo();
                op.setLeftExpression(exp.getLeftExpression());
                op.setRightExpression(element);
                double dist = this.computeComparisonOperator(op, data);
                if (!(dist < min)) continue;
                min = dist;
            }
            return min;
        }
        return this.cannotHandle(exp);
    }

    private double computeIsNull(IsNullExpression exp, DataRow data) {
        Object x = this.getValue(exp.getLeftExpression(), data);
        if (x == null && !exp.isNot()) {
            return 0.0;
        }
        if (x != null && exp.isNot()) {
            return 0.0;
        }
        return 1.0;
    }

    private double cannotHandle(Expression exp) {
        SimpleLogger.uniqueWarn("WARNING, cannot handle SQL expression type '" + exp.getClass().getSimpleName() + "' with value: " + exp.toString());
        return Double.MAX_VALUE;
    }

    private double computeAnd(AndExpression exp, DataRow data) {
        double b;
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double sum = a + (b = this.computeExpression(exp.getRightExpression(), data));
        if (sum < Math.max(a, b)) {
            return Double.MAX_VALUE;
        }
        return sum;
    }

    private double computeOr(OrExpression exp, DataRow data) {
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double b = this.computeExpression(exp.getRightExpression(), data);
        return Math.min(a, b);
    }

    private double computeComparisonOperator(ComparisonOperator exp, DataRow data) {
        Object left = this.getValue(exp.getLeftExpression(), data);
        Object right = this.getValue(exp.getRightExpression(), data);
        if (left instanceof Number && right instanceof Number) {
            double x = ((Number)left).doubleValue();
            double y = ((Number)right).doubleValue();
            return this.computerComparison(x, y, exp);
        }
        if (left instanceof String && right instanceof String) {
            return this.computeComparison(left.toString(), right.toString(), exp);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return this.computeBooleanComparison((Boolean)left, (Boolean)right, exp);
        }
        if (left == null || right == null) {
            return this.computeNullComparison(left, right, exp);
        }
        return this.cannotHandle(exp);
    }

    private double computeBooleanComparison(boolean x, boolean y, ComparisonOperator exp) {
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && x == y) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && x != y) {
            return 0.0;
        }
        return 1.0;
    }

    private boolean checkEqualOrNotOperator(ComparisonOperator exp) {
        return exp instanceof EqualsTo || exp instanceof NotEqualsTo;
    }

    private double computeNullComparison(Object x, Object y, ComparisonOperator exp) {
        assert (x == null || y == null);
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && x == y) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && x != y) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    private double computerComparison(double x, double y, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            return Math.abs(x - y);
        }
        if (exp instanceof GreaterThanEquals) {
            return x >= y ? 0.0 : y - x;
        }
        if (exp instanceof GreaterThan) {
            return x > y ? 0.0 : 1.0 + y - x;
        }
        if (exp instanceof MinorThanEquals) {
            return x <= y ? 0.0 : x - y;
        }
        if (exp instanceof MinorThan) {
            return x < y ? 0.0 : 1.0 + (x - y);
        }
        if (exp instanceof NotEqualsTo) {
            return x != y ? 0.0 : 1.0;
        }
        return this.cannotHandle(exp);
    }

    private double computeComparison(String a, String b, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            return StringTransformer.getLeftAlignmentDistance(a, b);
        }
        if (exp instanceof NotEqualsTo) {
            if (a.equals(b)) {
                return Double.MAX_VALUE;
            }
            return 0.0;
        }
        return this.cannotHandle(exp);
    }

    private Object getValue(Expression exp, DataRow data) {
        if (exp instanceof Column) {
            String name = ((Column)exp).getColumnName();
            String table = ((Column)exp).getTable().getName();
            table = this.tableAliases.getOrDefault(table, table);
            return data.getValueByName(name, table);
        }
        if (exp instanceof Parenthesis) {
            return this.getValue(((Parenthesis)exp).getExpression(), data);
        }
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getNotExcapedValue();
        }
        if (exp instanceof NullValue) {
            return null;
        }
        if (exp instanceof SignedExpression) {
            SignedExpression signed = (SignedExpression)exp;
            Object base = this.getValue(signed.getExpression(), data);
            if (signed.getSign() != '-') {
                return base;
            }
            if (base instanceof Long) {
                return -((Long)base).longValue();
            }
            if (base instanceof Double) {
                return -((Double)base).doubleValue();
            }
            if (base instanceof Float) {
                return Float.valueOf(-((Float)base).floatValue());
            }
            if (base instanceof Integer) {
                return -((Integer)base).intValue();
            }
            this.cannotHandle(exp);
            return null;
        }
        this.cannotHandle(exp);
        return null;
    }
}

