/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.db.QueryResult;
import org.evomaster.clientJava.controller.db.SqlScriptRunner;
import org.evomaster.clientJava.controller.internal.db.SelectHeuristics;
import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.parser.TokenMgrError;
import shaded.net.sf.jsqlparser.statement.select.Select;

public class SqlHandler {
    private final List<String> buffer = new CopyOnWriteArrayList<String>();
    private final List<Double> distances = new ArrayList<Double>();
    private volatile Connection connection;

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void handle(String sql) {
        Objects.requireNonNull(sql);
        this.buffer.add(sql);
    }

    public void reset() {
        this.buffer.clear();
        this.distances.clear();
    }

    public List<Double> getDistances() {
        if (this.connection == null) {
            return this.distances;
        }
        this.buffer.stream().filter(sql -> this.isSelect((String)sql)).forEach(sql -> {
            double dist = this.computeDistance((String)sql);
            this.distances.add(dist);
        });
        this.buffer.clear();
        return this.distances;
    }

    private boolean isSelect(String sql) {
        return sql.trim().toLowerCase().startsWith("select");
    }

    public static boolean isValidSql(String sql) {
        try {
            CCJSqlParserUtil.parse(sql);
            return true;
        }
        catch (JSQLParserException e) {
            return false;
        }
    }

    public Double computeDistance(String select) {
        QueryResult data;
        if (this.connection == null) {
            throw new IllegalStateException("Trying to calculate SQL distance with no DB connection");
        }
        try {
            Select select2 = (Select)CCJSqlParserUtil.parse(select);
        }
        catch (Exception | TokenMgrError e) {
            SimpleLogger.uniqueWarn("Cannot handle select query: " + select + "\n" + e.toString());
            return Double.MAX_VALUE;
        }
        String addedFields = SelectHeuristics.addFieldsToSelect(select);
        String noConstraints = SelectHeuristics.removeConstraints(addedFields);
        try {
            data = SqlScriptRunner.execCommand(this.connection, noConstraints);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        double dist = SelectHeuristics.computeDistance(select, data);
        return dist;
    }
}

