/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.visitor;

import org.evomaster.clientJava.instrumentation.ClassName;
import org.evomaster.clientJava.instrumentation.Constants;
import org.evomaster.clientJava.instrumentation.ObjectiveNaming;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;
import org.evomaster.clientJava.instrumentation.visitor.BranchCovMethodVisitor;
import org.evomaster.clientJava.instrumentation.visitor.LineCovMethodVisitor;
import org.evomaster.clientJava.instrumentation.visitor.SuccessCallMethodVisitor;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;

public class CoverageClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public CoverageClassVisitor(ClassVisitor cv, ClassName className) {
        super(327680, cv);
        this.bytecodeClassName = className.getBytecodeName();
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodSyntheticOrBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        ObjectiveRecorder.registerTarget(ObjectiveNaming.classObjectiveName(this.bytecodeClassName));
        mv = new LineCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new BranchCovMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        mv = new SuccessCallMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        return mv;
    }
}

