/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import org.evomaster.client.java.controller.SutHandler;
import org.evomaster.client.java.controller.api.dto.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.ExtraHeuristicsDto;
import org.evomaster.client.java.controller.api.dto.HeuristicEntryDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.database.execution.ExecutionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.db.SqlScriptRunner;
import org.evomaster.client.java.controller.internal.EMController;
import org.evomaster.client.java.controller.internal.db.SchemaExtractor;
import org.evomaster.client.java.controller.internal.db.SqlHandler;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.eclipse.jetty.server.AbstractNetworkConnector;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import shaded.org.eclipse.jetty.servlet.ServletHolder;
import shaded.org.glassfish.jersey.jackson.JacksonFeature;
import shaded.org.glassfish.jersey.logging.LoggingFeature;
import shaded.org.glassfish.jersey.server.ResourceConfig;
import shaded.org.glassfish.jersey.servlet.ServletContainer;

public abstract class SutController
implements SutHandler {
    private int controllerPort = 40100;
    private String controllerHost = "localhost";
    private final SqlHandler sqlHandler = new SqlHandler();
    private Server controllerServer;
    private DbSchemaDto schemaDto;
    private final List<ExtraHeuristicsDto> extras = new CopyOnWriteArrayList<ExtraHeuristicsDto>();
    private int actionIndex = -1;

    public final boolean startTheControllerServer() {
        ResourceConfig config = new ResourceConfig();
        config.register((Class)JacksonFeature.class);
        config.register(new EMController(this));
        config.register((Class)LoggingFeature.class);
        this.controllerServer = new Server(InetSocketAddress.createUnresolved(this.getControllerHost(), this.getControllerPort()));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.controllerServer.setErrorHandler(errorHandler);
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(config));
        ServletContextHandler context = new ServletContextHandler(this.controllerServer, "/controller/api/*");
        context.addServlet(servlet, "/*");
        try {
            this.controllerServer.start();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to start Jetty: " + e.getMessage());
            this.controllerServer.destroy();
        }
        this.newSearch();
        SimpleLogger.info("Started controller server on: " + this.controllerServer.getURI());
        return true;
    }

    public final boolean stopTheControllerServer() {
        try {
            this.controllerServer.stop();
            return true;
        }
        catch (Exception e) {
            SimpleLogger.error(e.toString());
            return false;
        }
    }

    public final int getControllerServerPort() {
        return ((AbstractNetworkConnector)this.controllerServer.getConnectors()[0]).getLocalPort();
    }

    public final int getControllerPort() {
        return this.controllerPort;
    }

    public final void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public final String getControllerHost() {
        return this.controllerHost;
    }

    public final void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    @Override
    public void execInsertionsIntoDatabase(List<InsertionDto> insertions) {
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalStateException("No connection to database");
        }
        try {
            SqlScriptRunner.execInsert(connection, insertions);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public final void handleSql(String sql) {
        Objects.requireNonNull(sql);
        this.sqlHandler.handle(sql);
    }

    public final void enableSqlHeuristics(boolean enabled) {
        this.sqlHandler.setCalculateHeuristics(enabled);
    }

    public final void initSqlHandler() {
        this.sqlHandler.setConnection(this.getConnection());
    }

    public final void resetExtraHeuristics() {
        this.sqlHandler.reset();
    }

    public final List<ExtraHeuristicsDto> getExtraHeuristics() {
        if (this.extras.size() == this.actionIndex) {
            this.extras.add(this.computeExtraHeuristics());
        }
        return new ArrayList<ExtraHeuristicsDto>(this.extras);
    }

    public final ExtraHeuristicsDto computeExtraHeuristics() {
        ExtraHeuristicsDto dto = new ExtraHeuristicsDto();
        if (this.sqlHandler.isCalculateHeuristics()) {
            ExecutionDto executionDto;
            this.sqlHandler.getDistances().stream().map(p -> new HeuristicEntryDto(HeuristicEntryDto.Type.SQL, HeuristicEntryDto.Objective.MINIMIZE_TO_ZERO, p.sqlCommand, p.distance)).forEach(h -> dto.heuristics.add((HeuristicEntryDto)h));
            dto.databaseExecutionDto = executionDto = this.sqlHandler.getExecutionDto();
        }
        return dto;
    }

    public final DbSchemaDto getSqlDatabaseSchema() {
        if (this.schemaDto != null) {
            return this.schemaDto;
        }
        if (this.getConnection() == null) {
            return null;
        }
        try {
            this.schemaDto = SchemaExtractor.extract(this.getConnection());
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to extract the SQL Database Schema: " + e.getMessage());
            return null;
        }
        return this.schemaDto;
    }

    public abstract void newSearch();

    public final void newTest() {
        this.actionIndex = -1;
        this.resetExtraHeuristics();
        this.extras.clear();
        this.newTestSpecificHandler();
    }

    public final void newAction(int actionIndex) {
        if (actionIndex > this.extras.size()) {
            this.extras.add(this.computeExtraHeuristics());
        }
        this.actionIndex = actionIndex;
        this.resetExtraHeuristics();
        this.newActionSpecificHandler(actionIndex);
    }

    public abstract void newTestSpecificHandler();

    public abstract void newActionSpecificHandler(int var1);

    public abstract boolean isInstrumentationActivated();

    public abstract boolean isSutRunning();

    public abstract String getPackagePrefixesToCover();

    public abstract List<AuthenticationDto> getInfoForAuthentication();

    public abstract Connection getConnection();

    public abstract String getDatabaseDriverName();

    public abstract List<TargetInfo> getTargetInfos(Collection<Integer> var1);

    public abstract List<AdditionalInfo> getAdditionalInfoList();

    public abstract ProblemInfo getProblemInfo();

    public abstract SutInfoDto.OutputFormat getPreferredOutputFormat();
}

