/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Objects;
import org.evomaster.client.java.controller.db.DataRow;
import org.evomaster.client.java.controller.db.QueryResult;
import org.evomaster.client.java.controller.internal.db.ParserUtils;
import org.evomaster.client.java.controller.internal.db.SqlNameContext;
import org.evomaster.client.java.instrumentation.testabilityboolean.StringTransformer;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.expression.NullValue;
import shaded.net.sf.jsqlparser.expression.Parenthesis;
import shaded.net.sf.jsqlparser.expression.SignedExpression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Between;
import shaded.net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.InExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import shaded.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Matches;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.Statement;

public class HeuristicsCalculator {
    private final SqlNameContext context;

    public HeuristicsCalculator(SqlNameContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public static double computeDistance(String statement, QueryResult data) {
        if (data.isEmpty()) {
            return Double.MAX_VALUE;
        }
        Statement stmt = ParserUtils.asStatement(statement);
        Expression where = ParserUtils.getWhere(stmt);
        if (where == null) {
            return 0.0;
        }
        SqlNameContext context = new SqlNameContext(stmt);
        HeuristicsCalculator calculator = new HeuristicsCalculator(context);
        double min = Double.MAX_VALUE;
        for (DataRow row : data.seeRows()) {
            double dist = calculator.computeExpression(where, row);
            if (dist == 0.0) {
                return 0.0;
            }
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    public double computeExpression(Expression exp, DataRow data) {
        if (exp instanceof Parenthesis) {
            return this.computeExpression(((Parenthesis)exp).getExpression(), data);
        }
        if (exp instanceof AndExpression) {
            return this.computeAnd((AndExpression)exp, data);
        }
        if (exp instanceof OrExpression) {
            return this.computeOr((OrExpression)exp, data);
        }
        if (exp instanceof Between) {
            return this.computeBetween((Between)exp, data);
        }
        if (exp instanceof ComparisonOperator) {
            return this.computeComparisonOperator((ComparisonOperator)exp, data);
        }
        if (exp instanceof ExistsExpression) {
            // empty if block
        }
        if (exp instanceof ExpressionList) {
            // empty if block
        }
        if (exp instanceof InExpression) {
            return this.computeInExpression((InExpression)exp, data);
        }
        if (exp instanceof IsNullExpression) {
            return this.computeIsNull((IsNullExpression)exp, data);
        }
        if (exp instanceof JsonOperator) {
            // empty if block
        }
        if (exp instanceof LikeExpression) {
            // empty if block
        }
        if (exp instanceof Matches) {
            // empty if block
        }
        if (exp instanceof MultiExpressionList) {
            // empty if block
        }
        if (exp instanceof NamedExpressionList) {
            // empty if block
        }
        if (exp instanceof RegExpMatchOperator) {
            // empty if block
        }
        return this.cannotHandle(exp);
    }

    private double computeBetween(Between between, DataRow data) {
        Instant start = this.getAsInstant(this.getValue(between.getBetweenExpressionStart(), data));
        Instant end = this.getAsInstant(this.getValue(between.getBetweenExpressionEnd(), data));
        Instant x = this.getAsInstant(this.getValue(between.getLeftExpression(), data));
        double after = this.computeComparison(x, start, (ComparisonOperator)new GreaterThanEquals());
        double before = this.computeComparison(x, end, (ComparisonOperator)new MinorThanEquals());
        return this.addDistances(after, before);
    }

    private double computeInExpression(InExpression exp, DataRow data) {
        ItemsList itemsList = exp.getRightItemsList();
        if (itemsList instanceof ExpressionList) {
            ExpressionList list = (ExpressionList)itemsList;
            if (exp.isNot()) {
                double max = 0.0;
                for (Expression element : list.getExpressions()) {
                    NotEqualsTo op = new NotEqualsTo();
                    op.setLeftExpression(exp.getLeftExpression());
                    op.setRightExpression(element);
                    double dist = this.computeComparisonOperator(op, data);
                    if (!(dist > max)) continue;
                    max = dist;
                    break;
                }
                return max;
            }
            double min = Double.MAX_VALUE;
            for (Expression element : list.getExpressions()) {
                EqualsTo op = new EqualsTo();
                op.setLeftExpression(exp.getLeftExpression());
                op.setRightExpression(element);
                double dist = this.computeComparisonOperator(op, data);
                if (!(dist < min)) continue;
                min = dist;
            }
            return min;
        }
        return this.cannotHandle(exp);
    }

    private double computeIsNull(IsNullExpression exp, DataRow data) {
        Object x = this.getValue(exp.getLeftExpression(), data);
        if (x == null && !exp.isNot()) {
            return 0.0;
        }
        if (x != null && exp.isNot()) {
            return 0.0;
        }
        return 1.0;
    }

    private double cannotHandle(Expression exp) {
        SimpleLogger.uniqueWarn("WARNING, cannot handle SQL expression type '" + exp.getClass().getSimpleName() + "' with value: " + exp.toString());
        return Double.MAX_VALUE;
    }

    private double computeAnd(AndExpression exp, DataRow data) {
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double b = this.computeExpression(exp.getRightExpression(), data);
        return this.addDistances(a, b);
    }

    private double addDistances(double a, double b) {
        double sum = a + b;
        if (sum < Math.max(a, b)) {
            return Double.MAX_VALUE;
        }
        return sum;
    }

    private double computeOr(OrExpression exp, DataRow data) {
        double a = this.computeExpression(exp.getLeftExpression(), data);
        double b = this.computeExpression(exp.getRightExpression(), data);
        return Math.min(a, b);
    }

    private Instant getAsInstant(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return timestamp.toInstant();
        }
        if (obj instanceof String) {
            try {
                return ZonedDateTime.parse(obj.toString()).toInstant();
            }
            catch (DateTimeParseException e) {
                DateTimeFormatter df = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy").toFormatter(Locale.ENGLISH);
                return LocalDate.parse(obj.toString(), df).atStartOfDay().toInstant(ZoneOffset.UTC);
            }
        }
        SimpleLogger.warn("Cannot handle time value for class: " + obj.getClass());
        return null;
    }

    private double computeComparisonOperator(ComparisonOperator exp, DataRow data) {
        Object left = this.getValue(exp.getLeftExpression(), data);
        Object right = this.getValue(exp.getRightExpression(), data);
        if (left instanceof Timestamp || right instanceof Timestamp) {
            Instant a = this.getAsInstant(left);
            Instant b = this.getAsInstant(right);
            if (a == null || b == null) {
                return this.cannotHandle(exp);
            }
            return this.computeComparison(a, b, exp);
        }
        if (left instanceof Number && right instanceof Number) {
            double x = ((Number)left).doubleValue();
            double y = ((Number)right).doubleValue();
            return this.computerComparison(x, y, exp);
        }
        if (left instanceof String && right instanceof String) {
            return this.computeComparison(left.toString(), right.toString(), exp);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return this.computeBooleanComparison((Boolean)left, (Boolean)right, exp);
        }
        if (left == null || right == null) {
            return this.computeNullComparison(left, right, exp);
        }
        return this.cannotHandle(exp);
    }

    private double computeComparison(Instant a, Instant b, ComparisonOperator exp) {
        if (a == null || b == null) {
            return Double.MAX_VALUE;
        }
        double dif = -Duration.between(a, b).toMillis();
        return this.computerComparison(dif, exp);
    }

    private double computeBooleanComparison(boolean x, boolean y, ComparisonOperator exp) {
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && x == y) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && x != y) {
            return 0.0;
        }
        return 1.0;
    }

    private boolean checkEqualOrNotOperator(ComparisonOperator exp) {
        return exp instanceof EqualsTo || exp instanceof NotEqualsTo;
    }

    private double computeNullComparison(Object x, Object y, ComparisonOperator exp) {
        assert (x == null || y == null);
        if (!this.checkEqualOrNotOperator(exp)) {
            return this.cannotHandle(exp);
        }
        if (exp instanceof EqualsTo && x == y) {
            return 0.0;
        }
        if (exp instanceof NotEqualsTo && x != y) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    private double computerComparison(double dif, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            return Math.abs(dif);
        }
        if (exp instanceof GreaterThanEquals) {
            return dif >= 0.0 ? 0.0 : -dif;
        }
        if (exp instanceof GreaterThan) {
            return dif > 0.0 ? 0.0 : 1.0 - dif;
        }
        if (exp instanceof MinorThanEquals) {
            return dif <= 0.0 ? 0.0 : dif;
        }
        if (exp instanceof MinorThan) {
            return dif < 0.0 ? 0.0 : 1.0 + dif;
        }
        if (exp instanceof NotEqualsTo) {
            return dif != 0.0 ? 0.0 : 1.0;
        }
        return this.cannotHandle(exp);
    }

    private double computerComparison(double x, double y, ComparisonOperator exp) {
        double dif = x - y;
        return this.computerComparison(dif, exp);
    }

    private double computeComparison(String a, String b, ComparisonOperator exp) {
        if (exp instanceof EqualsTo) {
            return StringTransformer.getLeftAlignmentDistance(a, b);
        }
        if (exp instanceof NotEqualsTo) {
            if (a.equals(b)) {
                return Double.MAX_VALUE;
            }
            return 0.0;
        }
        return this.cannotHandle(exp);
    }

    private Object getValue(Expression exp, DataRow data) {
        if (exp instanceof Column) {
            Column column = (Column)exp;
            String name = column.getColumnName();
            String table = this.context.getTableName(column);
            return data.getValueByName(name, table);
        }
        if (exp instanceof Parenthesis) {
            return this.getValue(((Parenthesis)exp).getExpression(), data);
        }
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getNotExcapedValue();
        }
        if (exp instanceof NullValue) {
            return null;
        }
        if (exp instanceof SignedExpression) {
            SignedExpression signed = (SignedExpression)exp;
            Object base = this.getValue(signed.getExpression(), data);
            if (signed.getSign() != '-') {
                return base;
            }
            if (base instanceof Long) {
                return -((Long)base).longValue();
            }
            if (base instanceof Double) {
                return -((Double)base).doubleValue();
            }
            if (base instanceof Float) {
                return Float.valueOf(-((Float)base).floatValue());
            }
            if (base instanceof Integer) {
                return -((Integer)base).intValue();
            }
            this.cannotHandle(exp);
            return null;
        }
        this.cannotHandle(exp);
        return null;
    }
}

