/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import org.evomaster.client.java.instrumentation.ClassName;
import org.evomaster.client.java.instrumentation.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class BranchCovMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private int latestVisitLine;
    private int jumpSinceLastLine;

    public BranchCovMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.latestVisitLine = 0;
        this.jumpSinceLastLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.latestVisitLine = line;
        this.jumpSinceLastLine = 0;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (this.methodName.equals("<clinit>")) {
            super.visitJumpInsn(opcode, label);
            return;
        }
        int branchId = this.jumpSinceLastLine++;
        ObjectiveRecorder.registerTarget(ObjectiveNaming.branchObjectiveName(this.className, this.latestVisitLine, branchId, true));
        ObjectiveRecorder.registerTarget(ObjectiveNaming.branchObjectiveName(this.className, this.latestVisitLine, branchId, false));
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.visitInsn(89);
                this.visitLdcInsn(opcode);
                this.visitLdcInsn(this.className);
                this.visitLdcInsn(this.latestVisitLine);
                this.visitLdcInsn(branchId);
                this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingBranchJump", "(IILjava/lang/String;II)V", ExecutionTracer.class.isInterface());
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.visitInsn(92);
                this.visitLdcInsn(opcode);
                this.visitLdcInsn(this.className);
                this.visitLdcInsn(this.latestVisitLine);
                this.visitLdcInsn(branchId);
                this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingBranchJump", "(IIILjava/lang/String;II)V", ExecutionTracer.class.isInterface());
                break;
            }
            case 165: 
            case 166: {
                this.visitInsn(92);
                this.visitLdcInsn(opcode);
                this.visitLdcInsn(this.className);
                this.visitLdcInsn(this.latestVisitLine);
                this.visitLdcInsn(branchId);
                this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingBranchJump", "(Ljava/lang/Object;Ljava/lang/Object;ILjava/lang/String;II)V", ExecutionTracer.class.isInterface());
                break;
            }
            case 198: 
            case 199: {
                this.visitInsn(89);
                this.visitLdcInsn(opcode);
                this.visitLdcInsn(this.className);
                this.visitLdcInsn(this.latestVisitLine);
                this.visitLdcInsn(branchId);
                this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingBranchJump", "(Ljava/lang/Object;ILjava/lang/String;II)V", ExecutionTracer.class.isInterface());
                break;
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxElementsAddedOnStackFrame = 6;
        super.visitMaxs(maxElementsAddedOnStackFrame + maxStack, maxLocals);
    }
}

