/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import org.evomaster.client.java.instrumentation.ClassName;
import org.evomaster.client.java.instrumentation.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.testabilityexception.ExceptionHeuristicsRegistry;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class SuccessCallMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private int currentLine;
    private int currentIndex;

    public SuccessCallMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.methodName.equals("<clinit>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        int index = this.currentIndex++;
        String targetId = ObjectiveNaming.successCallObjectiveName(this.className, this.currentLine, index);
        ObjectiveRecorder.registerTarget(targetId);
        if (!ExceptionHeuristicsRegistry.shouldHandle(owner, name, desc)) {
            this.addBaseInstrumentation(index, false);
        } else {
            this.addHeuristicInstrumentation(targetId, owner, name, desc);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.addBaseInstrumentation(index, true);
    }

    private void addHeuristicInstrumentation(String targetId, String owner, String name, String desc) {
        int inputs = ExceptionHeuristicsRegistry.numberOfInputs(owner, name, desc);
        if (inputs != 1) {
            throw new IllegalStateException("Bug in code instrumentation: number of inputs is " + inputs);
        }
        if (inputs == 1) {
            this.visitInsn(89);
        } else if (inputs == 2) {
            this.visitInsn(92);
        }
        this.visitLdcInsn(targetId);
        this.visitLdcInsn(owner);
        this.visitLdcInsn(name);
        this.visitLdcInsn(desc);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingExceptionMethod", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", ExecutionTracer.class.isInterface());
    }

    private void addBaseInstrumentation(int index, boolean covered) {
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.currentLine);
        this.visitLdcInsn(index);
        this.visitLdcInsn(covered);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingMethod", "(Ljava/lang/String;IIZ)V", ExecutionTracer.class.isInterface());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 4, maxLocals);
    }
}

