/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.testabilityexception;

import org.evomaster.client.java.instrumentation.testabilityexception.ExceptionHeuristics;

public class IntegerExceptionHeuristics {
    public static double parseInt(String input) {
        if (input == null) {
            return 0.05;
        }
        try {
            Integer.parseInt(input);
            return 1.0;
        }
        catch (Exception exception) {
            double base = 0.1;
            if (input.length() == 0) {
                return 0.1;
            }
            long distance = 0L;
            if (input.length() == 1) {
                distance += (long)ExceptionHeuristics.distanceToDigit(input.charAt(0));
            } else {
                for (int i = 0; i < input.length(); ++i) {
                    int digistDist = ExceptionHeuristics.distanceToDigit(input.charAt(i));
                    if (i == 0) {
                        distance += (long)Math.min(digistDist, ExceptionHeuristics.distanceToChar(input.charAt(i), '-'));
                        continue;
                    }
                    if (i > 9) {
                        distance += 65536L;
                        continue;
                    }
                    distance += (long)digistDist;
                }
            }
            assert (distance != 0L);
            return 0.1 + 0.9 / (double)(distance + 1L);
        }
    }
}

