/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import shaded.org.glassfish.jersey.internal.util.ReflectionHelper;
import shaded.org.glassfish.jersey.internal.util.collection.ClassTypePair;
import shaded.org.glassfish.jersey.server.Uri;
import shaded.org.glassfish.jersey.server.model.AnnotatedMethod;
import shaded.org.glassfish.jersey.server.model.ParamQualifier;

public class Parameter
implements AnnotatedElement {
    private static final Logger LOGGER = Logger.getLogger(Parameter.class.getName());
    private static final Map<Class, ParamAnnotationHelper> ANNOTATION_HELPER_MAP = Parameter.createParamAnnotationHelperMap();
    private final Annotation[] annotations;
    private final Annotation sourceAnnotation;
    private final Source source;
    private final String sourceName;
    private final boolean encoded;
    private final String defaultValue;
    private final Class<?> rawType;
    private final Type type;

    private static Map<Class, ParamAnnotationHelper> createParamAnnotationHelperMap() {
        WeakHashMap<Class, ParamAnnotationHelper<Context>> m = new WeakHashMap<Class, ParamAnnotationHelper<Context>>();
        m.put(Context.class, new ParamAnnotationHelper<Context>(){

            @Override
            public String getValueOf(Context a) {
                return null;
            }

            @Override
            public Source getSource() {
                return Source.CONTEXT;
            }
        });
        m.put(CookieParam.class, new ParamAnnotationHelper<CookieParam>(){

            @Override
            public String getValueOf(CookieParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.COOKIE;
            }
        });
        m.put(FormParam.class, new ParamAnnotationHelper<FormParam>(){

            @Override
            public String getValueOf(FormParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.FORM;
            }
        });
        m.put(HeaderParam.class, new ParamAnnotationHelper<HeaderParam>(){

            @Override
            public String getValueOf(HeaderParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.HEADER;
            }
        });
        m.put(MatrixParam.class, new ParamAnnotationHelper<MatrixParam>(){

            @Override
            public String getValueOf(MatrixParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.MATRIX;
            }
        });
        m.put(PathParam.class, new ParamAnnotationHelper<PathParam>(){

            @Override
            public String getValueOf(PathParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.PATH;
            }
        });
        m.put(QueryParam.class, new ParamAnnotationHelper<QueryParam>(){

            @Override
            public String getValueOf(QueryParam a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.QUERY;
            }
        });
        m.put(Suspended.class, new ParamAnnotationHelper<Suspended>(){

            @Override
            public String getValueOf(Suspended a) {
                return Suspended.class.getName();
            }

            @Override
            public Source getSource() {
                return Source.SUSPENDED;
            }
        });
        m.put(Uri.class, new ParamAnnotationHelper<Uri>(){

            @Override
            public String getValueOf(Uri a) {
                return a.value();
            }

            @Override
            public Source getSource() {
                return Source.URI;
            }
        });
        m.put(BeanParam.class, new ParamAnnotationHelper<BeanParam>(){

            @Override
            public String getValueOf(BeanParam a) {
                return null;
            }

            @Override
            public Source getSource() {
                return Source.BEAN_PARAM;
            }
        });
        return Collections.unmodifiableMap(m);
    }

    public static Parameter create(Class concreteClass, Class declaringClass, boolean encodeByDefault, Class<?> rawType, Type type, Annotation[] annotations) {
        if (null == annotations) {
            return null;
        }
        Annotation paramAnnotation = null;
        Source paramSource = null;
        String paramName = null;
        boolean paramEncoded = encodeByDefault;
        String paramDefault = null;
        for (Annotation annotation : annotations) {
            if (ANNOTATION_HELPER_MAP.containsKey(annotation.annotationType())) {
                ParamAnnotationHelper helper = ANNOTATION_HELPER_MAP.get(annotation.annotationType());
                paramAnnotation = annotation;
                paramSource = helper.getSource();
                paramName = helper.getValueOf(annotation);
                continue;
            }
            if (Encoded.class == annotation.annotationType()) {
                paramEncoded = true;
                continue;
            }
            if (DefaultValue.class == annotation.annotationType()) {
                paramDefault = ((DefaultValue)annotation).value();
                continue;
            }
            if (paramAnnotation != null && paramSource != Source.UNKNOWN) continue;
            paramAnnotation = annotation;
            paramSource = Source.UNKNOWN;
            paramName = Parameter.getValue(annotation);
        }
        if (paramAnnotation == null) {
            paramSource = Source.ENTITY;
        }
        ClassTypePair ct = ReflectionHelper.resolveGenericType(concreteClass, declaringClass, rawType, type);
        if (paramSource == Source.BEAN_PARAM) {
            return new BeanParameter(annotations, paramAnnotation, paramName, ct.rawClass(), ct.type(), paramEncoded, paramDefault);
        }
        return new Parameter(annotations, paramAnnotation, paramSource, paramName, ct.rawClass(), ct.type(), paramEncoded, paramDefault);
    }

    private static List<Parameter> create(Class concreteClass, Class declaringClass, boolean keepEncoded, Class[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = Parameter.create(concreteClass, declaringClass, keepEncoded, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
            if (null == parameter) {
                return Collections.emptyList();
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public static List<Parameter> create(Class concreteClass, Class declaringClass, Constructor<?> ctor, boolean keepEncoded) {
        Type[] genericParameterTypes;
        Class[] parameterTypes = ctor.getParameterTypes();
        if (parameterTypes.length != (genericParameterTypes = ctor.getGenericParameterTypes()).length) {
            Type[] _genericParameterTypes = new Type[parameterTypes.length];
            _genericParameterTypes[0] = parameterTypes[0];
            System.arraycopy(genericParameterTypes, 0, _genericParameterTypes, 1, genericParameterTypes.length);
            genericParameterTypes = _genericParameterTypes;
        }
        return Parameter.create(concreteClass, declaringClass, null != ctor.getAnnotation(Encoded.class) || keepEncoded, parameterTypes, genericParameterTypes, ctor.getParameterAnnotations());
    }

    public static List<Parameter> create(Class concreteClass, Class declaringClass, Method javaMethod, boolean keepEncoded) {
        AnnotatedMethod method = new AnnotatedMethod(javaMethod);
        return Parameter.create(concreteClass, declaringClass, null != method.getAnnotation(Encoded.class) || keepEncoded, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    public static Parameter overrideSource(Parameter original, Source source) {
        return new Parameter(original.annotations, original.sourceAnnotation, source, source.name(), original.rawType, original.type, original.encoded, original.defaultValue);
    }

    private static String getValue(Annotation a) {
        try {
            Method m = a.annotationType().getMethod("value", new Class[0]);
            if (m.getReturnType() != String.class) {
                return null;
            }
            return (String)m.invoke((Object)a, new Object[0]);
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, String.format("Unable to get the %s annotation value property", a.getClass().getName()), ex);
            }
            return null;
        }
    }

    private Parameter(Annotation[] markers, Annotation marker, Source source, String sourceName, Class<?> rawType, Type type, boolean encoded, String defaultValue) {
        this.annotations = markers;
        this.sourceAnnotation = marker;
        this.source = source;
        this.sourceName = sourceName;
        this.rawType = rawType;
        this.type = type;
        this.encoded = encoded;
        this.defaultValue = defaultValue;
    }

    public Annotation getSourceAnnotation() {
        return this.sourceAnnotation;
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isQualified() {
        for (Annotation a : this.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(ParamQualifier.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            return null;
        }
        for (Annotation a : this.annotations) {
            if (a.annotationType() != annotationClass) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    public String toString() {
        return String.format("Parameter [type=%s, source=%s, defaultValue=%s]", this.getRawType(), this.getSourceName(), this.getDefaultValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.encoded != parameter.encoded) {
            return false;
        }
        if (!Arrays.equals(this.annotations, parameter.annotations)) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(parameter.defaultValue) : parameter.defaultValue != null) {
            return false;
        }
        if (this.rawType != null ? !this.rawType.equals(parameter.rawType) : parameter.rawType != null) {
            return false;
        }
        if (this.source != parameter.source) {
            return false;
        }
        if (this.sourceAnnotation != null ? !this.sourceAnnotation.equals(parameter.sourceAnnotation) : parameter.sourceAnnotation != null) {
            return false;
        }
        if (this.sourceName != null ? !this.sourceName.equals(parameter.sourceName) : parameter.sourceName != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(parameter.type) : parameter.type != null);
    }

    public int hashCode() {
        int result = this.annotations != null ? Arrays.hashCode(this.annotations) : 0;
        result = 31 * result + (this.sourceAnnotation != null ? this.sourceAnnotation.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        result = 31 * result + (this.encoded ? 1 : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static class BeanParameter
    extends Parameter {
        private final Collection<Parameter> parameters;

        private BeanParameter(Annotation[] markers, Annotation marker, String sourceName, Class<?> rawType, Type type, boolean encoded, String defaultValue) {
            super(markers, marker, Source.BEAN_PARAM, sourceName, rawType, type, encoded, defaultValue);
            LinkedList<Parameter> parameters = new LinkedList<Parameter>();
            for (Field field : AccessController.doPrivileged(ReflectionHelper.getDeclaredFieldsPA(rawType))) {
                if (field.getDeclaredAnnotations().length <= 0) continue;
                Parameter beanParamParameter = Parameter.create(rawType, field.getDeclaringClass(), field.isAnnotationPresent(Encoded.class), field.getType(), field.getGenericType(), field.getAnnotations());
                parameters.add(beanParamParameter);
            }
            for (AccessibleObject accessibleObject : AccessController.doPrivileged(ReflectionHelper.getDeclaredConstructorsPA(rawType))) {
                for (Parameter parameter : Parameter.create(rawType, rawType, accessibleObject, false)) {
                    parameters.add(parameter);
                }
            }
            this.parameters = Collections.unmodifiableCollection(parameters);
        }

        public Collection<Parameter> getParameters() {
            return this.parameters;
        }
    }

    private static interface ParamAnnotationHelper<T extends Annotation> {
        public String getValueOf(T var1);

        public Source getSource();
    }

    public static enum Source {
        CONTEXT,
        COOKIE,
        ENTITY,
        FORM,
        HEADER,
        URI,
        MATRIX,
        PATH,
        QUERY,
        SUSPENDED,
        BEAN_PARAM,
        UNKNOWN;

    }
}

