/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.instrumentation.shared.ClassName;

public class ClassesToExclude {
    private static final List<String> excludedClasses;
    private static final List<String> includedClasses;

    private static List<String> getNotCommentedLines(InputStream excludedClassesStream) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(excludedClassesStream));){
            String line;
            while ((line = br.readLine()) != null) {
                String element = line.trim();
                if (element.startsWith("//") || element.isEmpty()) continue;
                list.add(element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getPackagePrefixesShouldNotBeInstrumented() {
        return excludedClasses;
    }

    public static boolean checkIfCanInstrument(ClassName cn) {
        String className = cn.getFullNameWithDots();
        block0: for (String s : excludedClasses) {
            if (!className.startsWith(s)) continue;
            for (String k : includedClasses) {
                if (!className.startsWith(k)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    static {
        InputStream excludedClassesStream = ClassesToExclude.class.getClassLoader().getResourceAsStream("skipInstrumentationList.txt");
        excludedClasses = ClassesToExclude.getNotCommentedLines(excludedClassesStream);
        InputStream includedClassesStream = ClassesToExclude.class.getClassLoader().getResourceAsStream("keepInstrumentationList.txt");
        includedClasses = ClassesToExclude.getNotCommentedLines(includedClassesStream);
    }
}

