/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.VertexFactory;
import shaded.org.jgrapht.generate.GraphGenerator;
import shaded.org.jgrapht.generate.RingGraphGenerator;

public class WheelGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String HUB_VERTEX = "Hub Vertex";
    private boolean inwardSpokes;
    private int size;

    public WheelGraphGenerator(int n) {
        this(n, true);
    }

    public WheelGraphGenerator(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n;
        this.inwardSpokes = bl;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, final VertexFactory<V> vertexFactory, Map<String, V> map) {
        if (this.size < 1) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        VertexFactory vertexFactory2 = new VertexFactory<V>(){

            @Override
            public V createVertex() {
                Object v = vertexFactory.createVertex();
                arrayList.add(v);
                return v;
            }
        };
        RingGraphGenerator ringGraphGenerator = new RingGraphGenerator(this.size - 1);
        ringGraphGenerator.generateGraph(graph, vertexFactory2, map);
        V v = vertexFactory.createVertex();
        graph.addVertex(v);
        if (map != null) {
            map.put(HUB_VERTEX, v);
        }
        for (Object e : arrayList) {
            if (this.inwardSpokes) {
                graph.addEdge(e, v);
                continue;
            }
            graph.addEdge(v, e);
        }
    }
}

