/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;

public abstract class ThirdPartyMethodReplacementClass
implements MethodReplacementClass {
    private final IdentityHashMap<ClassLoader, StateInfo> classInfoPerClassLoader = new IdentityHashMap();

    protected ThirdPartyMethodReplacementClass() {
    }

    private void initMethods(ClassLoader loader, StateInfo info) {
        Class<?> subclass = this.getClass();
        for (Method m : subclass.getDeclaredMethods()) {
            Method targetMethod;
            int i;
            Replacement r = m.getAnnotation(Replacement.class);
            if (r == null || r.id().isEmpty() || r.replacingConstructor()) continue;
            Class<?>[] inputs = m.getParameterTypes();
            Annotation[][] annotations = m.getParameterAnnotations();
            int start = 0;
            if (!r.replacingStatic()) {
                start = 1;
            }
            int end = inputs.length - 1;
            if (r.type() == ReplacementType.TRACKER) {
                end = inputs.length;
            }
            Class<?>[] reducedInputs = Arrays.copyOfRange(inputs, start, end);
            for (i = start; i < end; ++i) {
                Class<?> klazz;
                if (annotations[i].length <= 0 || (klazz = ReplacementUtils.getCastedToThirdParty(loader, annotations[i])) == null) continue;
                reducedInputs[i - start] = klazz;
            }
            for (i = 0; i < reducedInputs.length; ++i) {
                try {
                    reducedInputs[i] = loader.loadClass(reducedInputs[i].getName());
                    continue;
                }
                catch (ClassNotFoundException klazz) {
                    // empty catch block
                }
            }
            Class<?> targetClass = this.getTargetClass(loader);
            String replacementMethodName = ReplacementUtils.getPossiblyModifiedName(m);
            try {
                targetMethod = targetClass.getMethod(replacementMethodName, reducedInputs);
            }
            catch (NoSuchMethodException e) {
                try {
                    targetMethod = targetClass.getDeclaredMethod(replacementMethodName, reducedInputs);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("BUG in EvoMaster: " + e);
                }
            }
            String id = r.id();
            if (info.methods.containsKey(id)) {
                throw new IllegalStateException("Non-unique id: " + id);
            }
            info.methods.put(id, targetMethod);
        }
    }

    private void initConstructors(ClassLoader loader, StateInfo info) {
        Class<?> subclass = this.getClass();
        for (Method m : subclass.getDeclaredMethods()) {
            Replacement r = m.getAnnotation(Replacement.class);
            if (r == null || r.id().isEmpty() || !r.replacingConstructor()) continue;
            Class<?>[] inputs = m.getParameterTypes();
            int start = 0;
            int end = inputs.length - 1;
            if (r.type() == ReplacementType.TRACKER) {
                end = inputs.length;
            }
            Class<?>[] reducedInputs = Arrays.copyOfRange(inputs, start, end);
            Annotation[][] annotations = m.getParameterAnnotations();
            for (int i = start; i < end; ++i) {
                Class<?> klazz;
                if (annotations[i].length <= 0 || (klazz = ReplacementUtils.getCastedToThirdParty(loader, annotations[i])) == null) continue;
                reducedInputs[i - start] = klazz;
            }
            Constructor<?> targetConstructor = null;
            try {
                targetConstructor = this.getTargetClass(loader).getConstructor(reducedInputs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("BUG in EvoMaster: " + e);
            }
            String id = r.id();
            if (info.constructors.containsKey(id)) {
                throw new IllegalStateException("Non-unique id: " + id);
            }
            info.constructors.put(id, targetConstructor);
        }
    }

    protected abstract String getNameOfThirdPartyTargetClass();

    public static Method getOriginal(ThirdPartyMethodReplacementClass singleton, String id, Object obj) {
        Method original;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        Objects.requireNonNull(obj);
        ClassLoader loader = obj.getClass().getClassLoader();
        StateInfo info = singleton.classInfoPerClassLoader.get(loader);
        if (info == null) {
            info = ThirdPartyMethodReplacementClass.initializeClassInfo(singleton, loader);
        }
        if ((original = info.methods.get(id)) == null) {
            throw new IllegalArgumentException("No method exists with id: " + id);
        }
        return original;
    }

    private static StateInfo initializeClassInfo(ThirdPartyMethodReplacementClass singleton, ClassLoader loader) {
        Class<?> target = singleton.tryLoadingClass(loader);
        StateInfo info = new StateInfo();
        info.targetClass = target;
        singleton.initMethods(loader, info);
        singleton.initConstructors(loader, info);
        singleton.classInfoPerClassLoader.put(loader, info);
        return info;
    }

    public static Constructor getOriginalConstructor(ThirdPartyMethodReplacementClass singleton, String id) {
        Constructor original;
        StateInfo info;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        String callerName = ExecutionTracer.getLastCallerClass();
        if (callerName == null) {
            throw new IllegalStateException("No access to last caller class");
        }
        ClassLoader loader = UnitsInfoRecorder.getInstance().getFirstClassLoader(singleton.getTargetClassName());
        if (loader == null) {
            loader = UnitsInfoRecorder.getInstance().getClassLoaders(callerName).get(0);
        }
        if ((info = singleton.classInfoPerClassLoader.get(loader)) == null) {
            info = ThirdPartyMethodReplacementClass.initializeClassInfo(singleton, loader);
        }
        if ((original = info.constructors.get(id)) == null) {
            throw new IllegalArgumentException("No constructor exists with id: " + id);
        }
        return original;
    }

    private Class<?> tryLoadingClass(ClassLoader classLoader) {
        try {
            return classLoader.loadClass(this.getTargetClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ISSUE IN EVOMASTER: classloader problems when dealing with: " + this.getTargetClassName());
        }
    }

    @Override
    public final Class<?> getTargetClass() {
        throw new IllegalStateException("This method should never be called on a third-party replacement");
    }

    @Override
    public Class<?> getTargetClass(ClassLoader loader) {
        try {
            return loader.loadClass(this.getTargetClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public final String getTargetClassName() {
        return this.getNameOfThirdPartyTargetClass();
    }

    protected static Object getField(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StateInfo {
        public Class<?> targetClass;
        public final Map<String, Method> methods = new HashMap<String, Method>();
        public final Map<String, Constructor> constructors = new HashMap<String, Constructor>();

        private StateInfo() {
        }
    }
}

