/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ServletRequestClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final ServletRequestClassReplacement singleton = new ServletRequestClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "javax.servlet.ServletRequest";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="getInputStream", usageFilter=UsageFilter.ONLY_SUT, category=ReplacementCategory.BASE, castTo="javax.servlet.ServletInputStream")
    public static Object getInputStream(Object caller) throws Exception {
        if (caller == null) {
            throw new NullPointerException();
        }
        ExecutionTracer.markRawAccessOfHttpBodyPayload();
        Method original = ServletRequestClassReplacement.getOriginal(singleton, "getInputStream", caller);
        try {
            return original.invoke(caller, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
    }
}

