/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.generate;

import java.util.LinkedList;
import java.util.Map;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.VertexFactory;
import shaded.org.jgrapht.generate.GraphGenerator;

public class HyperCubeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int dim;

    public HyperCubeGraphGenerator(int n) {
        this.dim = n;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        int n;
        int n2 = (int)Math.pow(2.0, this.dim);
        LinkedList<V> linkedList = new LinkedList<V>();
        for (n = 0; n < n2; ++n) {
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            linkedList.add(v);
            if (map == null) continue;
            String string = Integer.toBinaryString(n);
            while (string.length() < this.dim) {
                string = "0" + string;
            }
            map.put(string, v);
        }
        for (n = 0; n < n2; ++n) {
            block3: for (int i = n + 1; i < n2; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    if ((i ^ n) != 1 << j) continue;
                    graph.addEdge(linkedList.get(n), linkedList.get(i));
                    continue block3;
                }
            }
        }
    }
}

