/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evomaster.client.java.controller.internal.db.OpenSearchCommandWithDistance;
import org.evomaster.client.java.controller.internal.db.OpenSearchDistanceWithMetrics;
import org.evomaster.client.java.controller.opensearch.OpenSearchHeuristicsCalculator;
import org.evomaster.client.java.instrumentation.OpenSearchCommand;
import org.evomaster.client.java.utils.SimpleLogger;

public class OpenSearchHandler {
    public static final String OPENSEARCH_CLIENT_CLASS_NAME = "org.opensearch.client.opensearch.OpenSearchClient";
    public static final String OPENSEARCH_CLIENT_INDEX_METHOD_NAME = "index";
    public static final String OPENSEARCH_CLIENT_SIZE_METHOD_NAME = "size";
    public static final String OPENSEARCH_CLIENT_BUILD_METHOD_NAME = "build";
    public static final String OPENSEARCH_CLIENT_SEARCH_METHOD_NAME = "search";
    public static final String OPENSEARCH_CLIENT_HITS_METHOD_NAME = "hits";
    public static final String OPENSEARCH_CLIENT_SEARCH_REQUEST_CLASS_NAME = "org.opensearch.client.opensearch.core.SearchRequest";
    public static final String OPENSEARCH_CLIENT_SEARCH_REQUEST_BUILDER_CLASS_NAME = "org.opensearch.client.opensearch.core.SearchRequest$Builder";
    private final List<OpenSearchCommand> commands;
    private final boolean calculateHeuristics;
    private final List<OpenSearchCommandWithDistance> commandsWithDistances;
    private final OpenSearchHeuristicsCalculator calculator = new OpenSearchHeuristicsCalculator();
    private Object openSearchClient = null;

    public OpenSearchHandler() {
        this.commands = new ArrayList<OpenSearchCommand>();
        this.commandsWithDistances = new ArrayList<OpenSearchCommandWithDistance>();
        this.calculateHeuristics = true;
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public void handle(OpenSearchCommand command) {
        this.commands.add(command);
    }

    public List<OpenSearchCommandWithDistance> getEvaluatedOpenSearchCommands() {
        this.commands.stream().filter(command -> command.getQuery() != null).forEach(openSearchCommand -> {
            OpenSearchDistanceWithMetrics distanceWithMetrics = this.computeCommandDistance((OpenSearchCommand)openSearchCommand);
            this.commandsWithDistances.add(new OpenSearchCommandWithDistance(openSearchCommand, distanceWithMetrics));
        });
        this.commands.clear();
        return this.commandsWithDistances;
    }

    private OpenSearchDistanceWithMetrics computeCommandDistance(OpenSearchCommand command) {
        List<String> indexName = command.getIndex();
        List<Object> documents = this.getDocuments(indexName);
        double min = Double.MAX_VALUE;
        int numberOfEvaluatedDocuments = 0;
        for (Object doc : documents) {
            double findDistance;
            ++numberOfEvaluatedDocuments;
            try {
                findDistance = this.calculator.computeExpression(command.getQuery(), doc);
            }
            catch (Exception ex) {
                SimpleLogger.uniqueWarn("Failed to compute find: " + command.getQuery() + " with data " + doc);
                findDistance = Double.MAX_VALUE;
            }
            if (findDistance == 0.0) {
                return new OpenSearchDistanceWithMetrics(0.0, numberOfEvaluatedDocuments);
            }
            if (!(findDistance < min)) continue;
            min = findDistance;
        }
        return new OpenSearchDistanceWithMetrics(min, numberOfEvaluatedDocuments);
    }

    private List<Object> getDocuments(List<String> indexNames) {
        try {
            Class<?> openSearchClientClass = this.openSearchClient.getClass();
            Class<?> searchRequestBuilderClass = Class.forName(OPENSEARCH_CLIENT_SEARCH_REQUEST_BUILDER_CLASS_NAME);
            Object searchRequestBuilder = searchRequestBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method indexMethod = searchRequestBuilderClass.getMethod(OPENSEARCH_CLIENT_INDEX_METHOD_NAME, List.class);
            indexMethod.invoke(searchRequestBuilder, indexNames);
            Method sizeMethod = searchRequestBuilderClass.getMethod(OPENSEARCH_CLIENT_SIZE_METHOD_NAME, Integer.class);
            sizeMethod.invoke(searchRequestBuilder, 10000);
            Method buildMethod = searchRequestBuilderClass.getMethod(OPENSEARCH_CLIENT_BUILD_METHOD_NAME, new Class[0]);
            Object searchRequest = buildMethod.invoke(searchRequestBuilder, new Object[0]);
            Method searchMethod = openSearchClientClass.getMethod(OPENSEARCH_CLIENT_SEARCH_METHOD_NAME, Class.forName(OPENSEARCH_CLIENT_SEARCH_REQUEST_CLASS_NAME), Class.class);
            Object searchResponse = searchMethod.invoke(this.openSearchClient, searchRequest, Object.class);
            Method hitsMethod = searchResponse.getClass().getMethod(OPENSEARCH_CLIENT_HITS_METHOD_NAME, new Class[0]);
            Object hitsContainer = hitsMethod.invoke(searchResponse, new Object[0]);
            Method hitsListMethod = hitsContainer.getClass().getMethod(OPENSEARCH_CLIENT_HITS_METHOD_NAME, new Class[0]);
            Object hitsList = hitsListMethod.invoke(hitsContainer, new Object[0]);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object hit : (List)hitsList) {
                Method hitSourceMethod = hit.getClass().getMethod("source", new Class[0]);
                result.add(hitSourceMethod.invoke(hit, new Object[0]));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve documents from OpenSearch indices: " + indexNames, e);
        }
    }

    private Object getDocuments() {
        return null;
    }

    public void setOpenSearchClient(Object openSearchClient) {
        this.openSearchClient = openSearchClient;
    }
}

