/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.opensearch;

import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.evomaster.client.java.controller.opensearch.OpenSearchQueryParser;
import org.evomaster.client.java.controller.opensearch.operations.ComparisonOperation;
import org.evomaster.client.java.controller.opensearch.operations.QueryOperation;
import org.evomaster.client.java.controller.opensearch.operations.TermOperation;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.sql.internal.TaintHandler;

public class OpenSearchHeuristicsCalculator {
    private final TaintHandler taintHandler;

    public OpenSearchHeuristicsCalculator() {
        this(null);
    }

    public OpenSearchHeuristicsCalculator(TaintHandler taintHandler) {
        this.taintHandler = taintHandler;
    }

    public double computeExpression(Object query, Object doc) {
        QueryOperation operation = this.getOperation(query);
        return this.calculateDistance(operation, doc);
    }

    private QueryOperation getOperation(Object query) {
        return new OpenSearchQueryParser().parse(query);
    }

    private double calculateDistance(QueryOperation operation, Object doc) {
        if (operation instanceof TermOperation) {
            return this.calculateDistanceForEquals((TermOperation)operation, doc);
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForEquals(TermOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, Math::abs);
    }

    private double calculateDistanceForComparisonOperation(ComparisonOperation<?> operation, Object doc, DoubleUnaryOperator calculateDistance) {
        Object expectedValue = operation.getValue();
        String field = operation.getFieldName();
        if (!((Map)doc).containsKey(field)) {
            return Double.MAX_VALUE;
        }
        Object actualValue = ((Map)doc).get(field);
        double dif = this.compareValues(actualValue, expectedValue);
        return calculateDistance.applyAsDouble(dif);
    }

    private double compareValues(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double x = ((Number)val1).doubleValue();
            double y = ((Number)val2).doubleValue();
            return x - y;
        }
        if (val1 instanceof String && val2 instanceof String) {
            if (this.taintHandler != null) {
                this.taintHandler.handleTaintForStringEquals((String)val1, (String)val2, false);
            }
            return DistanceHelper.getLeftAlignmentDistance((String)val1, (String)val2);
        }
        if (val1 instanceof Boolean && val2 instanceof Boolean) {
            return val1 == val2 ? 0.0 : 1.0;
        }
        if (val1 instanceof String && OpenSearchHeuristicsCalculator.isObjectId(val2)) {
            if (this.taintHandler != null) {
                this.taintHandler.handleTaintForStringEquals((String)val1, val2.toString(), false);
            }
            return DistanceHelper.getLeftAlignmentDistance((String)val1, val2.toString());
        }
        if (val2 instanceof String && OpenSearchHeuristicsCalculator.isObjectId(val1)) {
            if (this.taintHandler != null) {
                this.taintHandler.handleTaintForStringEquals(val1.toString(), val2.toString(), false);
            }
            return DistanceHelper.getLeftAlignmentDistance(val1.toString(), (String)val2);
        }
        if (OpenSearchHeuristicsCalculator.isObjectId(val2) && OpenSearchHeuristicsCalculator.isObjectId(val1)) {
            return DistanceHelper.getLeftAlignmentDistance(val1.toString(), val2.toString());
        }
        if (val1 instanceof List && val2 instanceof List) {
            return Double.MAX_VALUE;
        }
        return Double.MAX_VALUE;
    }

    private static boolean isObjectId(Object obj) {
        return obj.getClass().getName().equals("org.bson.types.ObjectId");
    }
}

