/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.opensearch.utils;

import java.lang.reflect.InvocationTargetException;
import org.evomaster.client.java.utils.SimpleLogger;

public class OpenSearchQueryHelper {
    public static String extractQueryKind(Object query) {
        try {
            Object kind = query.getClass().getMethod("_kind", new Class[0]).invoke(query, new Object[0]);
            return (String)kind.getClass().getMethod("name", new Class[0]).invoke(kind, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String extractFieldName(Object query, String structure) {
        try {
            Object term = query.getClass().getMethod(structure, new Class[0]).invoke(query, new Object[0]);
            return (String)term.getClass().getMethod("field", new Class[0]).invoke(term, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object extractFieldValue(Object query, String structure) {
        try {
            Object term = query.getClass().getMethod(structure, new Class[0]).invoke(query, new Object[0]);
            Object value = term.getClass().getMethod("value", new Class[0]).invoke(term, new Object[0]);
            return OpenSearchQueryHelper.extractTypedFieldValue(value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object extractTypedFieldValue(Object value) {
        try {
            String kindName;
            Object kind = value.getClass().getMethod("_kind", new Class[0]).invoke(value, new Object[0]);
            switch (kindName = (String)kind.getClass().getMethod("name", new Class[0]).invoke(kind, new Object[0])) {
                case "Double": {
                    if (!((Boolean)value.getClass().getMethod("isDouble", new Class[0]).invoke(value, new Object[0])).booleanValue()) break;
                    return value.getClass().getMethod("doubleValue", new Class[0]).invoke(value, new Object[0]);
                }
                case "Long": {
                    if (!((Boolean)value.getClass().getMethod("isLong", new Class[0]).invoke(value, new Object[0])).booleanValue()) break;
                    return value.getClass().getMethod("longValue", new Class[0]).invoke(value, new Object[0]);
                }
                case "Boolean": {
                    if (!((Boolean)value.getClass().getMethod("isBoolean", new Class[0]).invoke(value, new Object[0])).booleanValue()) break;
                    return value.getClass().getMethod("booleanValue", new Class[0]).invoke(value, new Object[0]);
                }
                case "String": {
                    if (!((Boolean)value.getClass().getMethod("isString", new Class[0]).invoke(value, new Object[0])).booleanValue()) break;
                    return value.getClass().getMethod("stringValue", new Class[0]).invoke(value, new Object[0]);
                }
                case "Null": {
                    return null;
                }
            }
            SimpleLogger.warn("[OpenSearch] [extractTypedFieldValue] found unknown kind: " + kindName);
            return value.getClass().getMethod("_get", new Class[0]).invoke(value, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

