/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.redis;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evomaster.client.java.controller.internal.db.redis.RedisDistanceWithMetrics;
import org.evomaster.client.java.controller.redis.RedisInfo;
import org.evomaster.client.java.controller.redis.RedisUtils;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.instrumentation.RedisCommand;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.RegexDistanceUtils;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;

public class RedisHeuristicsCalculator {
    public static final double MAX_REDIS_DISTANCE = 1.0;
    private final TaintHandler taintHandler;

    public RedisHeuristicsCalculator() {
        this(null);
    }

    public RedisHeuristicsCalculator(TaintHandler taintHandler) {
        this.taintHandler = taintHandler;
    }

    public RedisDistanceWithMetrics computeDistance(RedisCommand redisCommand, List<RedisInfo> redisInfo) {
        RedisCommand.RedisCommandType type = redisCommand.getType();
        try {
            switch (type) {
                case KEYS: {
                    String pattern = redisCommand.extractArgs().get(0);
                    return this.calculateDistanceForPattern(pattern, redisInfo);
                }
                case EXISTS: 
                case GET: 
                case HGETALL: 
                case SMEMBERS: {
                    String target = redisCommand.extractArgs().get(0);
                    return this.calculateDistanceForKeyMatch(target, redisInfo);
                }
                case HGET: {
                    String key = redisCommand.extractArgs().get(0);
                    return this.calculateDistanceForFieldInHash(key, redisInfo);
                }
                case SINTER: {
                    return this.calculateDistanceForIntersection(redisInfo);
                }
            }
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        catch (Exception e) {
            SimpleLogger.warn("Could not compute distance for " + (Object)((Object)type) + ": " + e.getMessage());
            return new RedisDistanceWithMetrics(1.0, 0);
        }
    }

    private RedisDistanceWithMetrics calculateDistanceForPattern(String pattern, List<RedisInfo> keys) {
        double minDist = 1.0;
        int eval = 0;
        try {
            String regex = RedisUtils.redisPatternToRegex(pattern);
        }
        catch (IllegalArgumentException e) {
            SimpleLogger.uniqueWarn("Invalid Redis pattern. Cannot compute regex for: " + pattern);
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        for (RedisInfo k : keys) {
            double d = TruthnessUtils.normalizeValue(RegexDistanceUtils.getStandardDistance(k.getKey(), RedisUtils.redisPatternToRegex(pattern)));
            minDist = Math.min(minDist, d);
            ++eval;
            if (d != 0.0) continue;
            return new RedisDistanceWithMetrics(0.0, eval);
        }
        return new RedisDistanceWithMetrics(minDist, eval);
    }

    private RedisDistanceWithMetrics calculateDistanceForKeyMatch(String targetKey, List<RedisInfo> candidateKeys) {
        if (candidateKeys.isEmpty()) {
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        double minDist = 1.0;
        int evaluated = 0;
        for (RedisInfo k : candidateKeys) {
            try {
                long rawDist = DistanceHelper.getLeftAlignmentDistance(targetKey, k.getKey());
                double normDist = TruthnessUtils.normalizeValue(rawDist);
                minDist = Math.min(minDist, normDist);
                ++evaluated;
                if (normDist != 0.0) continue;
                return new RedisDistanceWithMetrics(0.0, evaluated);
            }
            catch (Exception ex) {
                SimpleLogger.uniqueWarn("Failed to compute distance for key " + k + ": " + ex.getMessage());
            }
        }
        return new RedisDistanceWithMetrics(minDist, evaluated);
    }

    private RedisDistanceWithMetrics calculateDistanceForFieldInHash(String targetKey, List<RedisInfo> keys) {
        if (keys.isEmpty()) {
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        double minDist = 1.0;
        int evaluated = 0;
        for (RedisInfo k : keys) {
            try {
                long keyDist = DistanceHelper.getLeftAlignmentDistance(targetKey, k.getKey());
                double fieldDist = k.hasField() ? 0.0 : 1.0;
                double combined = TruthnessUtils.normalizeValue((double)keyDist + fieldDist);
                minDist = Math.min(minDist, combined);
                ++evaluated;
                if (combined != 0.0) continue;
                return new RedisDistanceWithMetrics(0.0, evaluated);
            }
            catch (Exception ex) {
                SimpleLogger.uniqueWarn("Failed HGET distance on " + k + ": " + ex.getMessage());
            }
        }
        return new RedisDistanceWithMetrics(minDist, evaluated);
    }

    private RedisDistanceWithMetrics calculateDistanceForIntersection(List<RedisInfo> keys) {
        if (keys == null || keys.isEmpty()) {
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        double total = 0.0;
        int evaluated = 0;
        HashSet<String> currentIntersection = null;
        for (int i = 0; i < keys.size(); ++i) {
            RedisInfo k = keys.get(i);
            String type = k.getType();
            if (!"set".equalsIgnoreCase(type)) {
                return new RedisDistanceWithMetrics(1.0, evaluated);
            }
            Set<String> set = k.getMembers();
            if (set == null) {
                set = Collections.emptySet();
            }
            if (i == 0) {
                currentIntersection = new HashSet<String>(set);
                double d0 = currentIntersection.isEmpty() ? 1.0 : 0.0;
                total += d0;
                ++evaluated;
                continue;
            }
            HashSet newIntersection = new HashSet(currentIntersection);
            newIntersection.retainAll(set);
            double di = newIntersection.isEmpty() ? this.computeSetIntersectionDistance(currentIntersection, set) : 0.0;
            total += di;
            ++evaluated;
            currentIntersection = newIntersection;
        }
        return new RedisDistanceWithMetrics(total / (double)keys.size(), evaluated);
    }

    private double computeSetIntersectionDistance(Set<String> s1, Set<String> s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return 1.0;
        }
        double min = 1.0;
        for (String a : s1) {
            for (String b : s2) {
                long raw = DistanceHelper.getLeftAlignmentDistance(a, b);
                double norm = TruthnessUtils.normalizeValue(raw);
                if ((min = Math.min(min, norm)) != 0.0) continue;
                return 0.0;
            }
        }
        return min;
    }
}

