/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RedisCommand
implements Serializable {
    private final RedisCommandType type;
    private final String[] args;
    private final boolean successfullyExecuted;
    private final long executionTime;

    public RedisCommand(RedisCommandType type, String[] args, boolean successfullyExecuted, long executionTime) {
        this.type = type;
        this.args = args != null ? Arrays.copyOf(args, args.length) : new String[]{};
        this.successfullyExecuted = successfullyExecuted;
        this.executionTime = executionTime;
    }

    public RedisCommandType getType() {
        return this.type;
    }

    public String[] getArgs() {
        return this.args;
    }

    public List<String> extractArgs() {
        ArrayList<String> parameters = new ArrayList<String>();
        for (String arg : this.args) {
            parameters.add(arg.substring(arg.indexOf(60) + 1, arg.indexOf(62)));
        }
        return parameters;
    }

    public boolean getSuccessfullyExecuted() {
        return this.successfullyExecuted;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public static enum RedisCommandType {
        DEL("del", "mixed", false),
        EVAL("eval", "script", false),
        EVALSHA("evalsha", "script", false),
        EXISTS("exists", "mixed", true),
        GET("get", "string", true),
        HGET("hget", "hash", true),
        HGETALL("hgetall", "hash", true),
        INCR("incr", "string", false),
        KEYS("keys", "none", true),
        SET("set", "string", false),
        PUBLISH("publish", "pubsub", false),
        SADD("sadd", "set", false),
        SETEX("setex", "string", false),
        SINTER("sinter", "set", true),
        SMEMBERS("smembers", "set", true),
        SPOP("spop", "set", false),
        SREM("srem", "set", false),
        SUBSCRIBE("subscribe", "pubsub", false),
        UNSUBSCRIBE("unsubscribe", "pubsub", false),
        OTHER("other", "none", false);

        private final String label;
        private final String dataType;
        private final boolean calculateHeuristic;

        private RedisCommandType(String label, String dataType, boolean shouldCalculateHeuristic) {
            this.label = label;
            this.dataType = dataType;
            this.calculateHeuristic = shouldCalculateHeuristic;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDataType() {
            return this.dataType;
        }

        public boolean shouldCalculateHeuristic() {
            return this.calculateHeuristic;
        }
    }
}

